/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.util.DeprecationException;
import org.apache.commons.lang.enums.ValuedEnum;

public class Deprecation {
    public static final Logger logger = new LoggerWrapper((Logger)new ConsoleLogger());
    private static final int DEBUG_VALUE = 0;
    private static final int INFO_VALUE = 1;
    private static final int WARN_VALUE = 2;
    private static final int ERROR_VALUE = 3;
    private static final int FATAL_VALUE = 3;
    private static final int FATAL_ERROR_VALUE = 4;
    public static final LogLevel DEBUG = new LogLevel("DEBUG", 0);
    public static final LogLevel INFO = new LogLevel("INFO", 1);
    public static final LogLevel WARN = new LogLevel("WARN", 2);
    public static final LogLevel ERROR = new LogLevel("ERROR", 3);
    public static final LogLevel FATAL_ERROR = new LogLevel("FATAL_ERROR", 4);
    static /* synthetic */ Class class$org$apache$cocoon$util$Deprecation$LogLevel;

    public static void setLogger(Logger newLogger) {
        ((LoggerWrapper)logger).setLogger(newLogger);
    }

    public static void setForbiddenLevel(LogLevel level) {
        if (level == null) {
            level = ERROR;
        }
        ((LoggerWrapper)logger).setForbiddenLevel(level);
    }

    private static class LoggerWrapper
    implements Logger {
        private Logger realLogger;
        private int forbiddenLevel = 3;

        public LoggerWrapper(Logger logger) {
            this.realLogger = logger;
        }

        public void setLogger(Logger logger) {
            while (logger instanceof LoggerWrapper) {
                logger = ((LoggerWrapper)logger).realLogger;
            }
            this.realLogger = logger;
        }

        public void setForbiddenLevel(LogLevel level) {
            this.forbiddenLevel = level.getValue();
        }

        private void throwException(int level, String message) {
            if (level >= this.forbiddenLevel) {
                throw new DeprecationException(message);
            }
        }

        private boolean isThrowingException(int level) {
            return level >= this.forbiddenLevel;
        }

        public void debug(String message) {
            this.realLogger.debug(message);
            this.throwException(0, message);
        }

        public void debug(String message, Throwable thr) {
            this.realLogger.debug(message, thr);
            this.throwException(0, message);
        }

        public void info(String message) {
            this.realLogger.info(message);
            this.throwException(1, message);
        }

        public void info(String message, Throwable thr) {
            this.realLogger.info(message, thr);
            this.throwException(1, message);
        }

        public void warn(String message) {
            this.realLogger.warn(message);
            this.throwException(2, message);
        }

        public void warn(String message, Throwable thr) {
            this.realLogger.warn(message, thr);
            this.throwException(2, message);
        }

        public void error(String message) {
            this.realLogger.error(message);
            this.throwException(3, message);
        }

        public void error(String message, Throwable thr) {
            this.realLogger.error(message, thr);
            this.throwException(3, message);
        }

        public void fatalError(String message) {
            this.realLogger.fatalError(message);
            this.throwException(3, message);
        }

        public void fatalError(String message, Throwable thr) {
            this.realLogger.fatalError(message, thr);
            this.throwException(3, message);
        }

        public boolean isDebugEnabled() {
            return this.isThrowingException(0) || this.realLogger.isDebugEnabled();
        }

        public boolean isInfoEnabled() {
            return this.isThrowingException(1) || this.realLogger.isInfoEnabled();
        }

        public boolean isWarnEnabled() {
            return this.isThrowingException(2) || this.realLogger.isWarnEnabled();
        }

        public boolean isErrorEnabled() {
            return this.isThrowingException(3) || this.realLogger.isErrorEnabled();
        }

        public boolean isFatalErrorEnabled() {
            return true;
        }

        public Logger getChildLogger(String message) {
            return this.realLogger.getChildLogger(message);
        }
    }

    public static final class LogLevel
    extends ValuedEnum {
        private LogLevel(String text, int value) {
            super(text, value);
        }

        public static LogLevel getLevel(String level) {
            return (LogLevel)ValuedEnum.getEnum((Class)(class$org$apache$cocoon$util$Deprecation$LogLevel == null ? (class$org$apache$cocoon$util$Deprecation$LogLevel = Deprecation.class$("org.apache.cocoon.util.Deprecation$LogLevel")) : class$org$apache$cocoon$util$Deprecation$LogLevel), (String)level);
        }
    }
}

