/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.optional.pipeline.components.sax.betwixt;

import java.beans.IntrospectionException;
import java.io.IOException;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.pipeline.util.StringRepresentation;
import org.apache.cocoon.sax.AbstractSAXGenerator;
import org.apache.cocoon.sax.SAXConsumer;
import org.apache.commons.betwixt.BindingConfiguration;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.io.SAXBeanWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class BetwixtBeanGenerator
extends AbstractSAXGenerator {
    private Object bean;
    private SAXBeanWriter saxBeanWriter;
    private BindingConfiguration bindingConfiguration;
    private XMLIntrospector xmlIntrospector;

    public BetwixtBeanGenerator(Object bean) {
        this(bean, null, null);
    }

    public BetwixtBeanGenerator(Object bean, BindingConfiguration bindingConfiguration, XMLIntrospector xmlIntrospector) {
        if (bean == null) {
            throw new IllegalArgumentException("A Bean has to be passed.");
        }
        this.bean = bean;
        this.bindingConfiguration = bindingConfiguration;
        this.xmlIntrospector = xmlIntrospector;
    }

    protected void setSAXConsumer(SAXConsumer xmlConsumer) {
        this.saxBeanWriter = new SAXBeanWriter((ContentHandler)xmlConsumer);
        if (this.bindingConfiguration != null) {
            this.saxBeanWriter.setBindingConfiguration(this.bindingConfiguration);
        }
        if (this.xmlIntrospector != null) {
            this.saxBeanWriter.setXMLIntrospector(this.xmlIntrospector);
        }
    }

    public void execute() {
        try {
            this.saxBeanWriter.write(this.bean);
        }
        catch (IOException e) {
            throw new ProcessingException("Fatal protocol violation", (Throwable)e);
        }
        catch (SAXException e) {
            throw new ProcessingException("Fatal XML error", (Throwable)e);
        }
        catch (IntrospectionException e) {
            throw new ProcessingException("Impossible to analyze input bean", (Throwable)e);
        }
    }

    public String toString() {
        return StringRepresentation.buildString((Object)((Object)this), (String[])new String[]{"bean=" + this.bean, "bindingConfiguration=" + this.bindingConfiguration, "xmlIntrospector=" + this.xmlIntrospector});
    }
}

