/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.optional.pipeline.components.sax.solr;

import java.net.MalformedURLException;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.sax.AbstractSAXTransformer;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.StrUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SolrConsumer
extends AbstractSAXTransformer {
    private SolrServer solr = null;
    private boolean isNull = false;
    private SolrInputDocument doc = new SolrInputDocument();
    private float boost = 1.0f;
    private String name = null;
    private String text = "";

    public SolrConsumer(String url) throws MalformedURLException {
        this.solr = new CommonsHttpSolrServer(url);
    }

    public SolrConsumer(SolrServer server) {
        this.solr = server;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.text = this.text + new String(ch, start, length);
        this.getSAXConsumer().characters(ch, start, length);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("field".equals(localName)) {
            this.text = "";
            this.boost = 1.0f;
            if (atts.getValue("name") != null) {
                this.name = atts.getValue("name");
            }
            if (atts.getValue("boost") != null) {
                this.boost = Float.parseFloat(atts.getValue("boost"));
            }
            if (atts.getValue("null") != null) {
                this.isNull = StrUtils.parseBoolean((String)atts.getValue("null"));
            }
        }
        this.getSAXConsumer().startElement(uri, localName, qName, atts);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("docs".equals(localName)) {
            try {
                this.solr.commit();
            }
            catch (Exception e) {
                throw new ProcessingException("Unable to commit the Solr documents.", (Throwable)e);
            }
        } else if ("doc".equals(localName)) {
            try {
                this.solr.add(this.doc);
                this.doc = new SolrInputDocument();
            }
            catch (Exception e) {
                throw new ProcessingException("Unable to add the Solr document.", (Throwable)e);
            }
        } else if ("field".equals(localName) && !this.isNull && this.text.length() > 0) {
            this.doc.addField(this.name, (Object)this.text, this.boost);
            this.boost = 1.0f;
        }
        this.getSAXConsumer().endElement(uri, localName, qName);
    }
}

