/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sax.xpointer;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.apache.cocoon.sax.xpointer.AbstractPointerPart;
import org.apache.cocoon.sax.xpointer.XPointerContext;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class XPointerPart
extends AbstractPointerPart {
    private static final SAXTransformerFactory TRAX_FACTORY = (SAXTransformerFactory)TransformerFactory.newInstance();
    private static final String XMLNS_PATTERN = "xmlns:%s=\"%s\"";
    private static final String XSLT_PATTERN = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" %s><xsl:template match=\"%s\"><xsl:copy-of select=\".\"/></xsl:template></xsl:stylesheet>";
    private static final Map<String, Templates> TEMPLATES = new HashMap<String, Templates>();
    private final String expression;
    private TransformerHandler traxHandler;

    public XPointerPart(String expression) {
        this.expression = expression;
    }

    public void setUp(XPointerContext xpointerContext) throws SAXException, IOException {
        Templates templates;
        if (TEMPLATES.containsKey(this.expression)) {
            templates = TEMPLATES.get(this.expression);
        } else {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> namespace : xpointerContext.getNamespaces().entrySet()) {
                builder.append('\n');
                builder.append(String.format(XMLNS_PATTERN, namespace.getKey(), namespace.getValue()));
            }
            String xmlNamespaces = builder.toString();
            String xslt = String.format(XSLT_PATTERN, xmlNamespaces, this.expression);
            StreamSource source = new StreamSource(new StringReader(xslt));
            try {
                templates = TRAX_FACTORY.newTemplates(source);
            }
            catch (TransformerConfigurationException tce) {
                throw new SAXException("XPointer expression '" + this.expression + "' not valid as used in the fragment identifier '" + xpointerContext.getXPointer() + "'", tce);
            }
            TEMPLATES.put(this.expression, templates);
        }
        SAXResult result = new SAXResult();
        result.setHandler(xpointerContext.getSaxConsumer());
        try {
            this.traxHandler = TRAX_FACTORY.newTransformerHandler(templates);
            this.traxHandler.setResult(result);
        }
        catch (TransformerConfigurationException tce) {
            throw new SAXException("Impossible to initialize transformer handler for XPointer expression '" + this.expression + "' as used in the fragment identifier '" + xpointerContext.getXPointer() + "'", tce);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.traxHandler.characters(ch, start, length);
    }

    public void endDocument() throws SAXException {
        this.traxHandler.endDocument();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.traxHandler.endElement(uri, localName, qName);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.traxHandler.endPrefixMapping(prefix);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.traxHandler.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.traxHandler.processingInstruction(target, data);
    }

    public void setDocumentLocator(Locator locator) {
        this.traxHandler.setDocumentLocator(locator);
    }

    public void skippedEntity(String name) throws SAXException {
        this.traxHandler.skippedEntity(name);
    }

    public void startDocument() throws SAXException {
        this.traxHandler.startDocument();
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.traxHandler.startElement(uri, localName, qName, atts);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.traxHandler.startPrefixMapping(prefix, uri);
    }
}

