/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache.cdi;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import javax.cache.annotation.CacheInvocationContext;
import javax.cache.annotation.CacheInvocationParameter;
import javax.interceptor.InvocationContext;
import org.apache.commons.jcs.jcache.cdi.CacheInvocationParameterImpl;
import org.apache.commons.jcs.jcache.cdi.CacheMethodDetailsImpl;

public class CacheInvocationContextImpl<A extends Annotation>
extends CacheMethodDetailsImpl<A>
implements CacheInvocationContext<A> {
    private CacheInvocationParameter[] parameters = null;

    public CacheInvocationContextImpl(InvocationContext delegate, A cacheAnnotation, String cacheName) {
        super(delegate, cacheAnnotation, cacheName);
    }

    public Object getTarget() {
        return this.delegate.getTarget();
    }

    public CacheInvocationParameter[] getAllParameters() {
        if (this.parameters == null) {
            this.parameters = this.doGetAllParameters(null);
        }
        return this.parameters;
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        throw new IllegalArgumentException(cls.getName());
    }

    protected CacheInvocationParameter[] doGetAllParameters(Integer[] indexes) {
        Object[] args = this.delegate.getParameters();
        Class<?>[] parameterTypes = this.getMethod().getParameterTypes();
        Annotation[][] parameterAnnotations = this.getMethod().getParameterAnnotations();
        CacheInvocationParameter[] parametersAsArray = new CacheInvocationParameter[indexes == null ? args.length : indexes.length];
        if (indexes == null) {
            for (int i = 0; i < args.length; ++i) {
                parametersAsArray[i] = this.newCacheInvocationParameterImpl(parameterTypes[i], args[i], parameterAnnotations[i], i);
            }
        } else {
            for (int idx = 0; idx < indexes.length; ++idx) {
                int i = indexes[idx];
                parametersAsArray[i] = this.newCacheInvocationParameterImpl(parameterTypes[i], args[i], parameterAnnotations[i], i);
            }
        }
        return parametersAsArray;
    }

    private CacheInvocationParameterImpl newCacheInvocationParameterImpl(Class<?> type, Object arg, Annotation[] annotations, int i) {
        return new CacheInvocationParameterImpl(type, arg, new HashSet<Annotation>(Arrays.asList(annotations)), i);
    }
}

