/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.genetics;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.commons.math3.genetics.ChromosomePair;
import org.apache.commons.math3.genetics.CycleCrossover;
import org.apache.commons.math3.genetics.DummyBinaryChromosome;
import org.apache.commons.math3.genetics.DummyListChromosome;
import org.junit.Assert;
import org.junit.Test;

public class CycleCrossoverTest {
    @Test
    public void testCrossoverExample() {
        Integer[] p1 = new Integer[]{8, 4, 7, 3, 6, 2, 5, 1, 9, 0};
        Integer[] p2 = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        DummyListChromosome p1c = new DummyListChromosome(p1);
        DummyListChromosome p2c = new DummyListChromosome(p2);
        CycleCrossover cp = new CycleCrossover();
        ChromosomePair pair = cp.crossover((Chromosome)p1c, (Chromosome)p2c);
        Object[] c1 = ((DummyListChromosome)pair.getFirst()).getRepresentation().toArray(new Integer[p1.length]);
        Object[] c2 = ((DummyListChromosome)pair.getSecond()).getRepresentation().toArray(new Integer[p2.length]);
        Object[] c1e = new Integer[]{8, 1, 2, 3, 4, 5, 6, 7, 9, 0};
        Object[] c2e = new Integer[]{0, 4, 7, 3, 6, 2, 5, 1, 8, 9};
        Assert.assertArrayEquals((Object[])c1e, (Object[])c1);
        Assert.assertArrayEquals((Object[])c2e, (Object[])c2);
    }

    @Test
    public void testCrossoverExample2() {
        Integer[] p1 = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        Integer[] p2 = new Integer[]{9, 3, 7, 8, 2, 6, 5, 1, 4};
        DummyListChromosome p1c = new DummyListChromosome(p1);
        DummyListChromosome p2c = new DummyListChromosome(p2);
        CycleCrossover cp = new CycleCrossover();
        ChromosomePair pair = cp.crossover((Chromosome)p1c, (Chromosome)p2c);
        Object[] c1 = ((DummyListChromosome)pair.getFirst()).getRepresentation().toArray(new Integer[p1.length]);
        Object[] c2 = ((DummyListChromosome)pair.getSecond()).getRepresentation().toArray(new Integer[p2.length]);
        Object[] c1e = new Integer[]{1, 3, 7, 4, 2, 6, 5, 8, 9};
        Object[] c2e = new Integer[]{9, 2, 3, 8, 5, 6, 7, 1, 4};
        Assert.assertArrayEquals((Object[])c1e, (Object[])c1);
        Assert.assertArrayEquals((Object[])c2e, (Object[])c2);
    }

    @Test
    public void testCrossover() {
        Integer[] p1 = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        Integer[] p2 = new Integer[]{10, 9, 8, 7, 6, 5, 4, 3, 2, 1};
        DummyListChromosome p1c = new DummyListChromosome(p1);
        DummyListChromosome p2c = new DummyListChromosome(p2);
        CycleCrossover cp = new CycleCrossover(true);
        for (int i = 0; i < 20; ++i) {
            ChromosomePair pair = cp.crossover((Chromosome)p1c, (Chromosome)p2c);
            Integer[] c1 = ((DummyListChromosome)pair.getFirst()).getRepresentation().toArray(new Integer[p1.length]);
            Integer[] c2 = ((DummyListChromosome)pair.getSecond()).getRepresentation().toArray(new Integer[p2.length]);
            int index = 0;
            for (Integer j : c1) {
                if (!p1[index].equals(j)) {
                    Assert.assertEquals((Object)j, (Object)p2[index]);
                } else {
                    Assert.assertEquals((Object)j, (Object)p1[index]);
                }
                ++index;
            }
            index = 0;
            for (Integer k : c2) {
                if (p2[index] != k) {
                    Assert.assertEquals((Object)k, (Object)p1[index]);
                } else {
                    Assert.assertEquals((Object)k, (Object)p2[index]);
                }
                ++index;
            }
        }
    }

    @Test(expected=DimensionMismatchException.class)
    public void testCrossoverDimensionMismatchException() {
        Integer[] p1 = new Integer[]{1, 0, 1, 0, 0, 1, 0, 1, 1};
        Integer[] p2 = new Integer[]{0, 1, 1, 0, 1};
        DummyBinaryChromosome p1c = new DummyBinaryChromosome(p1);
        DummyBinaryChromosome p2c = new DummyBinaryChromosome(p2);
        CycleCrossover cp = new CycleCrossover();
        cp.crossover((Chromosome)p1c, (Chromosome)p2c);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testCrossoverInvalidFixedLengthChromosomeFirst() {
        Integer[] p1 = new Integer[]{1, 0, 1, 0, 0, 1, 0, 1, 1};
        DummyBinaryChromosome p1c = new DummyBinaryChromosome(p1);
        Chromosome p2c = new Chromosome(){

            public double fitness() {
                return 0.0;
            }
        };
        CycleCrossover cp = new CycleCrossover();
        cp.crossover((Chromosome)p1c, p2c);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testCrossoverInvalidFixedLengthChromosomeSecond() {
        Integer[] p1 = new Integer[]{1, 0, 1, 0, 0, 1, 0, 1, 1};
        DummyBinaryChromosome p2c = new DummyBinaryChromosome(p1);
        Chromosome p1c = new Chromosome(){

            public double fitness() {
                return 0.0;
            }
        };
        CycleCrossover cp = new CycleCrossover();
        cp.crossover(p1c, (Chromosome)p2c);
    }
}

