/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.random.GaussianRandomGenerator;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.NormalizedRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.UncorrelatedRandomVectorGenerator;
import org.apache.commons.math3.stat.descriptive.moment.VectorialCovariance;
import org.apache.commons.math3.stat.descriptive.moment.VectorialMean;
import org.junit.Assert;
import org.junit.Test;

public class UncorrelatedRandomVectorGeneratorTest {
    private double[] mean = new double[]{0.0, 1.0, -3.0, 2.3};
    private double[] standardDeviation = new double[]{1.0, 2.0, 10.0, 0.1};
    private UncorrelatedRandomVectorGenerator generator;

    public UncorrelatedRandomVectorGeneratorTest() {
        JDKRandomGenerator rg = new JDKRandomGenerator();
        rg.setSeed(17399225432L);
        this.generator = new UncorrelatedRandomVectorGenerator(this.mean, this.standardDeviation, (NormalizedRandomGenerator)new GaussianRandomGenerator((RandomGenerator)rg));
    }

    @Test
    public void testMeanAndCorrelation() {
        VectorialMean meanStat = new VectorialMean(this.mean.length);
        VectorialCovariance covStat = new VectorialCovariance(this.mean.length, true);
        for (int i = 0; i < 10000; ++i) {
            double[] v = this.generator.nextVector();
            meanStat.increment(v);
            covStat.increment(v);
        }
        double[] estimatedMean = meanStat.getResult();
        RealMatrix estimatedCorrelation = covStat.getResult();
        for (int i = 0; i < estimatedMean.length; ++i) {
            double scale;
            Assert.assertEquals((double)this.mean[i], (double)estimatedMean[i], (double)0.07);
            for (int j = 0; j < i; ++j) {
                scale = this.standardDeviation[i] * this.standardDeviation[j];
                Assert.assertEquals((double)0.0, (double)(estimatedCorrelation.getEntry(i, j) / scale), (double)0.03);
            }
            scale = this.standardDeviation[i] * this.standardDeviation[i];
            Assert.assertEquals((double)1.0, (double)(estimatedCorrelation.getEntry(i, i) / scale), (double)0.025);
        }
    }
}

