/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.moment;

import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.descriptive.moment.SemiVariance;
import org.junit.Assert;
import org.junit.Test;

public class SemiVarianceTest {
    @Test
    public void testInsufficientData() {
        double[] nothing = null;
        SemiVariance sv = new SemiVariance();
        try {
            sv.evaluate(nothing);
            Assert.fail((String)"null is not a valid data array.");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            sv.setVarianceDirection(SemiVariance.UPSIDE_VARIANCE);
            sv.evaluate(nothing);
            Assert.fail((String)"null is not a valid data array.");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        nothing = new double[]{};
        Assert.assertTrue((boolean)Double.isNaN(sv.evaluate(nothing)));
    }

    @Test
    public void testSingleDown() {
        SemiVariance sv = new SemiVariance();
        double[] values = new double[]{50.0};
        double singletest = sv.evaluate(values);
        Assert.assertEquals((double)0.0, (double)singletest, (double)0.0);
    }

    @Test
    public void testSingleUp() {
        SemiVariance sv = new SemiVariance(SemiVariance.UPSIDE_VARIANCE);
        double[] values = new double[]{50.0};
        double singletest = sv.evaluate(values);
        Assert.assertEquals((double)0.0, (double)singletest, (double)0.0);
    }

    @Test
    public void testSample() {
        double[] values = new double[]{-2.0, 2.0, 4.0, -2.0, 22.0, 11.0, 3.0, 14.0, 5.0};
        int length = values.length;
        double mean = StatUtils.mean((double[])values);
        SemiVariance sv = new SemiVariance();
        double downsideSemiVariance = sv.evaluate(values);
        Assert.assertEquals((double)(TestUtils.sumSquareDev(new double[]{-2.0, 2.0, 4.0, -2.0, 3.0, 5.0}, mean) / (double)(length - 1)), (double)downsideSemiVariance, (double)1.0E-14);
        sv.setVarianceDirection(SemiVariance.UPSIDE_VARIANCE);
        double upsideSemiVariance = sv.evaluate(values);
        Assert.assertEquals((double)(TestUtils.sumSquareDev(new double[]{22.0, 11.0, 14.0}, mean) / (double)(length - 1)), (double)upsideSemiVariance, (double)1.0E-14);
        Assert.assertEquals((double)StatUtils.variance((double[])values), (double)(downsideSemiVariance + upsideSemiVariance), (double)1.0E-11);
    }

    @Test
    public void testPopulation() {
        double[] values = new double[]{-2.0, 2.0, 4.0, -2.0, 22.0, 11.0, 3.0, 14.0, 5.0};
        SemiVariance sv = new SemiVariance(false);
        double singletest = sv.evaluate(values);
        Assert.assertEquals((double)19.556, (double)singletest, (double)0.01);
        sv.setVarianceDirection(SemiVariance.UPSIDE_VARIANCE);
        singletest = sv.evaluate(values);
        Assert.assertEquals((double)36.222, (double)singletest, (double)0.01);
    }

    @Test
    public void testNonMeanCutoffs() {
        double[] values = new double[]{-2.0, 2.0, 4.0, -2.0, 22.0, 11.0, 3.0, 14.0, 5.0};
        SemiVariance sv = new SemiVariance(false);
        double singletest = sv.evaluate(values, 1.0, SemiVariance.DOWNSIDE_VARIANCE, false, 0, values.length);
        Assert.assertEquals((double)(TestUtils.sumSquareDev(new double[]{-2.0, -2.0}, 1.0) / (double)values.length), (double)singletest, (double)0.01);
        singletest = sv.evaluate(values, 3.0, SemiVariance.UPSIDE_VARIANCE, false, 0, values.length);
        Assert.assertEquals((double)(TestUtils.sumSquareDev(new double[]{4.0, 22.0, 11.0, 14.0, 5.0}, 3.0) / (double)values.length), (double)singletest, (double)0.01);
    }

    @Test
    public void testVarianceDecompMeanCutoff() {
        double[] values = new double[]{-2.0, 2.0, 4.0, -2.0, 22.0, 11.0, 3.0, 14.0, 5.0};
        double variance = StatUtils.variance((double[])values);
        SemiVariance sv = new SemiVariance(true);
        sv.setVarianceDirection(SemiVariance.DOWNSIDE_VARIANCE);
        double lower = sv.evaluate(values);
        sv.setVarianceDirection(SemiVariance.UPSIDE_VARIANCE);
        double upper = sv.evaluate(values);
        Assert.assertEquals((double)variance, (double)(lower + upper), (double)1.0E-11);
    }

    @Test
    public void testVarianceDecompNonMeanCutoff() {
        double[] values = new double[]{-2.0, 2.0, 4.0, -2.0, 22.0, 11.0, 3.0, 14.0, 5.0};
        double target = 0.0;
        double totalSumOfSquares = TestUtils.sumSquareDev(values, target);
        SemiVariance sv = new SemiVariance(true);
        sv.setVarianceDirection(SemiVariance.DOWNSIDE_VARIANCE);
        double lower = sv.evaluate(values, target);
        sv.setVarianceDirection(SemiVariance.UPSIDE_VARIANCE);
        double upper = sv.evaluate(values, target);
        Assert.assertEquals((double)(totalSumOfSquares / (double)(values.length - 1)), (double)(lower + upper), (double)1.0E-11);
    }

    @Test
    public void testNoVariance() {
        double[] values = new double[]{100.0, 100.0, 100.0, 100.0};
        SemiVariance sv = new SemiVariance();
        Assert.assertEquals((double)0.0, (double)sv.evaluate(values), (double)1.0E-11);
        Assert.assertEquals((double)0.0, (double)sv.evaluate(values, 100.0), (double)1.0E-11);
        Assert.assertEquals((double)0.0, (double)sv.evaluate(values, 100.0, SemiVariance.UPSIDE_VARIANCE, false, 0, values.length), (double)1.0E-11);
    }
}

