/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.moment;

import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatisticAbstractTest;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.SecondMoment;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.apache.commons.math3.util.MathArrays;
import org.junit.Assert;
import org.junit.Test;

public class VarianceTest
extends StorelessUnivariateStatisticAbstractTest {
    protected Variance stat;

    public UnivariateStatistic getUnivariateStatistic() {
        return new Variance();
    }

    public double expectedValue() {
        return this.var;
    }

    public double expectedWeightedValue() {
        return this.weightedVar;
    }

    @Test
    public void testNaN() {
        StandardDeviation std = new StandardDeviation();
        Assert.assertTrue((boolean)Double.isNaN(std.getResult()));
        std.increment(1.0);
        Assert.assertEquals((double)0.0, (double)std.getResult(), (double)0.0);
    }

    @Test
    public void testPopulation() {
        double[] values = new double[]{-1.0, 3.1, 4.0, -2.1, 22.0, 11.7, 3.0, 14.0};
        SecondMoment m = new SecondMoment();
        m.evaluate(values);
        Variance v1 = new Variance();
        v1.setBiasCorrected(false);
        Assert.assertEquals((double)this.populationVariance(values), (double)v1.evaluate(values), (double)1.0E-14);
        v1.incrementAll(values);
        Assert.assertEquals((double)this.populationVariance(values), (double)v1.getResult(), (double)1.0E-14);
        v1 = new Variance(false, m);
        Assert.assertEquals((double)this.populationVariance(values), (double)v1.getResult(), (double)1.0E-14);
        v1 = new Variance(false);
        Assert.assertEquals((double)this.populationVariance(values), (double)v1.evaluate(values), (double)1.0E-14);
        v1.incrementAll(values);
        Assert.assertEquals((double)this.populationVariance(values), (double)v1.getResult(), (double)1.0E-14);
    }

    protected double populationVariance(double[] v) {
        double mean = new Mean().evaluate(v);
        double sum = 0.0;
        for (int i = 0; i < v.length; ++i) {
            sum += (v[i] - mean) * (v[i] - mean);
        }
        return sum / (double)v.length;
    }

    @Test
    public void testWeightedVariance() {
        Variance variance = new Variance();
        Assert.assertEquals((double)this.expectedWeightedValue(), (double)variance.evaluate(this.testArray, this.testWeightsArray, 0, this.testArray.length), (double)this.getTolerance());
        Assert.assertEquals((double)this.expectedValue(), (double)variance.evaluate(this.testArray, this.unitWeightsArray, 0, this.testArray.length), (double)this.getTolerance());
        Assert.assertEquals((double)this.expectedValue(), (double)variance.evaluate(this.testArray, MathArrays.normalizeArray((double[])this.identicalWeightsArray, (double)this.testArray.length), 0, this.testArray.length), (double)this.getTolerance());
    }
}

