/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.api;

import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.W3CRDFSyntax;

public interface RDFSyntax {
    public static final RDFSyntax JSONLD = W3CRDFSyntax.JSONLD;
    public static final RDFSyntax TURTLE = W3CRDFSyntax.TURTLE;
    public static final RDFSyntax NQUADS = W3CRDFSyntax.NQUADS;
    public static final RDFSyntax NTRIPLES = W3CRDFSyntax.NTRIPLES;
    public static final RDFSyntax RDFA = W3CRDFSyntax.RDFA;
    public static final RDFSyntax RDFXML = W3CRDFSyntax.RDFXML;
    public static final RDFSyntax TRIG = W3CRDFSyntax.TRIG;

    public String name();

    public String title();

    public String mediaType();

    default public Set<String> mediaTypes() {
        return Collections.singleton(this.mediaType());
    }

    public String fileExtension();

    default public Set<String> fileExtensions() {
        return Collections.singleton(this.fileExtension());
    }

    public boolean supportsDataset();

    public IRI iri();

    public boolean equals(Object var1);

    public int hashCode();

    public static Set<RDFSyntax> w3cSyntaxes() {
        return W3CRDFSyntax.syntaxes;
    }

    public static Optional<RDFSyntax> byMediaType(String mediaType) {
        String type = mediaType.toLowerCase(Locale.ROOT).split("\\s*;", 2)[0];
        return RDFSyntax.w3cSyntaxes().stream().filter(t -> t.mediaTypes().contains(type)).findAny();
    }

    public static Optional<RDFSyntax> byFileExtension(String fileExtension) {
        String ext = fileExtension.toLowerCase(Locale.ROOT);
        return RDFSyntax.w3cSyntaxes().stream().filter(t -> t.fileExtensions().contains(ext)).findAny();
    }

    public static Optional<RDFSyntax> byName(String name) {
        return RDFSyntax.w3cSyntaxes().stream().filter(t -> t.name().equals(name)).findAny();
    }
}

