/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.shape;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.SharedStateObjectSampler;
import org.apache.commons.rng.sampling.shape.Coordinates;

public abstract class TriangleSampler
implements SharedStateObjectSampler<double[]> {
    private static final int TWO_D = 2;
    private static final int THREE_D = 3;
    private final UniformRandomProvider rng;

    TriangleSampler(UniformRandomProvider rng) {
        this.rng = rng;
    }

    @Override
    public double[] sample() {
        double t;
        double s = this.rng.nextDouble();
        double spt = s + (t = this.rng.nextDouble());
        if (spt > 1.0) {
            return this.createSample(s - 1.0 + t, 1.0 - s, 1.0 - t);
        }
        return this.createSample(1.0 - spt, s, t);
    }

    protected abstract double[] createSample(double var1, double var3, double var5);

    @Override
    public abstract TriangleSampler withUniformRandomProvider(UniformRandomProvider var1);

    public static TriangleSampler of(UniformRandomProvider rng, double[] a, double[] b, double[] c) {
        int dimension = a.length;
        if (dimension != b.length || dimension != c.length) {
            throw new IllegalArgumentException("Mismatch of vertex dimensions: " + dimension + ',' + b.length + ',' + c.length);
        }
        Coordinates.requireFinite(a, "Vertex a");
        Coordinates.requireFinite(b, "Vertex b");
        Coordinates.requireFinite(c, "Vertex c");
        if (dimension == 2) {
            return new TriangleSampler2D(rng, a, b, c);
        }
        if (dimension == 3) {
            return new TriangleSampler3D(rng, a, b, c);
        }
        if (dimension > 3) {
            return new TriangleSamplerND(rng, a, b, c);
        }
        throw new IllegalArgumentException("Unsupported dimension: " + dimension);
    }

    private static class TriangleSamplerND
    extends TriangleSampler {
        private final double[] a;
        private final double[] b;
        private final double[] c;

        TriangleSamplerND(UniformRandomProvider rng, double[] a, double[] b, double[] c) {
            super(rng);
            this.a = (double[])a.clone();
            this.b = (double[])b.clone();
            this.c = (double[])c.clone();
        }

        TriangleSamplerND(UniformRandomProvider rng, TriangleSamplerND source) {
            super(rng);
            this.a = source.a;
            this.b = source.b;
            this.c = source.c;
        }

        @Override
        public double[] createSample(double p1msmt, double s, double t) {
            double[] x = new double[this.a.length];
            for (int i = 0; i < x.length; ++i) {
                x[i] = p1msmt * this.a[i] + s * this.b[i] + t * this.c[i];
            }
            return x;
        }

        @Override
        public TriangleSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new TriangleSamplerND(rng, this);
        }
    }

    private static class TriangleSampler3D
    extends TriangleSampler {
        private final double ax;
        private final double ay;
        private final double az;
        private final double bx;
        private final double by;
        private final double bz;
        private final double cx;
        private final double cy;
        private final double cz;

        TriangleSampler3D(UniformRandomProvider rng, double[] a, double[] b, double[] c) {
            super(rng);
            this.ax = a[0];
            this.ay = a[1];
            this.az = a[2];
            this.bx = b[0];
            this.by = b[1];
            this.bz = b[2];
            this.cx = c[0];
            this.cy = c[1];
            this.cz = c[2];
        }

        TriangleSampler3D(UniformRandomProvider rng, TriangleSampler3D source) {
            super(rng);
            this.ax = source.ax;
            this.ay = source.ay;
            this.az = source.az;
            this.bx = source.bx;
            this.by = source.by;
            this.bz = source.bz;
            this.cx = source.cx;
            this.cy = source.cy;
            this.cz = source.cz;
        }

        @Override
        public double[] createSample(double p1msmt, double s, double t) {
            return new double[]{p1msmt * this.ax + s * this.bx + t * this.cx, p1msmt * this.ay + s * this.by + t * this.cy, p1msmt * this.az + s * this.bz + t * this.cz};
        }

        @Override
        public TriangleSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new TriangleSampler3D(rng, this);
        }
    }

    private static class TriangleSampler2D
    extends TriangleSampler {
        private final double ax;
        private final double ay;
        private final double bx;
        private final double by;
        private final double cx;
        private final double cy;

        TriangleSampler2D(UniformRandomProvider rng, double[] a, double[] b, double[] c) {
            super(rng);
            this.ax = a[0];
            this.ay = a[1];
            this.bx = b[0];
            this.by = b[1];
            this.cx = c[0];
            this.cy = c[1];
        }

        TriangleSampler2D(UniformRandomProvider rng, TriangleSampler2D source) {
            super(rng);
            this.ax = source.ax;
            this.ay = source.ay;
            this.bx = source.bx;
            this.by = source.by;
            this.cx = source.cx;
            this.cy = source.cy;
        }

        @Override
        public double[] createSample(double p1msmt, double s, double t) {
            return new double[]{p1msmt * this.ax + s * this.bx + t * this.cx, p1msmt * this.ay + s * this.by + t * this.cy};
        }

        @Override
        public TriangleSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new TriangleSampler2D(rng, this);
        }
    }
}

