/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.simple.internal;

import org.apache.commons.rng.simple.internal.MixFunctions;

final class Conversions {
    private static final long GOLDEN_RATIO = -7046029254386353131L;

    private Conversions() {
    }

    static int intSizeFromByteSize(int size) {
        return size + 3 >>> 2;
    }

    static int longSizeFromByteSize(int size) {
        return size + 7 >>> 3;
    }

    static int intSizeFromLongSize(int size) {
        int n = size << 1;
        return (n | n >> 31) & Integer.MAX_VALUE;
    }

    static int longSizeFromIntSize(int size) {
        return size + 1 >>> 1;
    }

    static long int2Long(int input) {
        return MixFunctions.stafford13((long)input + -7046029254386353131L);
    }

    static int[] int2IntArray(int input, int length) {
        return Conversions.long2IntArray(input, length);
    }

    static long[] int2LongArray(int input, int length) {
        return Conversions.long2LongArray(input, length);
    }

    static int long2Int(long input) {
        return (int)input ^ (int)(input >>> 32);
    }

    static int[] long2IntArray(long input, int length) {
        long v = input == 7046029254386353131L ? input ^ 0xFFFFFFFFFFFFFFFFL : input;
        int[] output = new int[length];
        int n = length & 0xFFFFFFFE;
        for (int i = 0; i < n; i += 2) {
            long x = MixFunctions.stafford13(v += -7046029254386353131L);
            output[i] = (int)x;
            output[i + 1] = (int)(x >>> 32);
        }
        if (n < length) {
            output[n] = (int)MixFunctions.stafford13(v + -7046029254386353131L);
        }
        return output;
    }

    static long[] long2LongArray(long input, int length) {
        long v = input;
        long[] output = new long[length];
        for (int i = 0; i < length; ++i) {
            output[i] = MixFunctions.stafford13(v += -7046029254386353131L);
        }
        return output;
    }

    static int intArray2Int(int[] input) {
        int output = 0;
        for (int i : input) {
            output ^= i;
        }
        return output;
    }

    static long intArray2Long(int[] input) {
        long output = 0L;
        int n = input.length;
        for (int i = 0; i < n; ++i) {
            output ^= ((long)input[i] & 0xFFFFFFFFL) << ((i & 1) << 5);
        }
        return output;
    }

    static long[] intArray2LongArray(int[] input, int length) {
        long[] output = new long[length];
        int n = (int)Math.min((long)input.length, (long)length * 2L);
        for (int i = 0; i < n; ++i) {
            int n2 = i >> 1;
            output[n2] = output[n2] | ((long)input[i] & 0xFFFFFFFFL) << ((i & 1) << 5);
        }
        return output;
    }

    static int longArray2Int(long[] input) {
        return Conversions.long2Int(Conversions.longArray2Long(input));
    }

    static long longArray2Long(long[] input) {
        long output = 0L;
        for (long i : input) {
            output ^= i;
        }
        return output;
    }

    static int[] longArray2IntArray(long[] input, int length) {
        int[] output = new int[length];
        int n = (int)Math.min((long)input.length * 2L, (long)length);
        for (int i = 0; i < n; ++i) {
            output[i] = (int)(input[i >> 1] >>> ((i & 1) << 5));
        }
        return output;
    }

    static int byteArray2Int(byte[] input) {
        int output = 0;
        int n = input.length;
        for (int i = 0; i < n; ++i) {
            output ^= (input[i] & 0xFF) << ((i & 3) << 3);
        }
        return output;
    }

    static int[] byteArray2IntArray(byte[] input, int length) {
        int[] output = new int[length];
        int n = (int)Math.min((long)input.length, (long)length * 4L);
        for (int i = 0; i < n; ++i) {
            int n2 = i >> 2;
            output[n2] = output[n2] | (input[i] & 0xFF) << ((i & 3) << 3);
        }
        return output;
    }

    static long byteArray2Long(byte[] input) {
        long output = 0L;
        int n = input.length;
        for (int i = 0; i < n; ++i) {
            output ^= ((long)input[i] & 0xFFL) << ((i & 7) << 3);
        }
        return output;
    }

    static long[] byteArray2LongArray(byte[] input, int length) {
        long[] output = new long[length];
        int n = (int)Math.min((long)input.length, (long)length * 8L);
        for (int i = 0; i < n; ++i) {
            int n2 = i >> 3;
            output[n2] = output[n2] | ((long)input[i] & 0xFFL) << ((i & 7) << 3);
        }
        return output;
    }
}

