/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.SimilarityScore;

public class SimilarityScoreFrom<R> {
    private final SimilarityScore<R> similarityScore;
    private final CharSequence left;

    public SimilarityScoreFrom(SimilarityScore<R> similarityScore, CharSequence left) {
        if (similarityScore == null) {
            throw new IllegalArgumentException("The edit distance may not be null.");
        }
        this.similarityScore = similarityScore;
        this.left = left;
    }

    public R apply(CharSequence right) {
        return this.similarityScore.apply(this.left, right);
    }

    public CharSequence getLeft() {
        return this.left;
    }

    public SimilarityScore<R> getSimilarityScore() {
        return this.similarityScore;
    }
}

