/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.constituency.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.model.AbstractModel;
import opennlp.model.MaxentModel;
import opennlp.tools.chunker.Chunker;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.cmdline.parser.ParserTool;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.parser.chunking.Parser;
import opennlp.tools.parser.lang.en.HeadRules;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.POSTagger;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.postag.TagDictionary;
import opennlp.tools.util.Span;
import org.apache.ctakes.constituency.parser.ParserWrapper;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.syntax.PunctuationToken;
import org.apache.ctakes.typesystem.type.syntax.TerminalTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TopTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.StringArray;

public class MaxentParserWrapper
implements ParserWrapper {
    Parser parser = null;
    private boolean useTagDictionary = true;
    private boolean useCaseSensitiveTagDictionary = true;
    private String parseStr = "";
    Logger logger = Logger.getLogger((String)this.getClass().getName());

    public MaxentParserWrapper(String dataDir) {
        try {
            File d = new File(dataDir);
            AbstractModel buildModel = null;
            AbstractModel checkModel = null;
            POSTaggerME posTagger = null;
            ChunkerME chunker = null;
            HeadRules headRules = null;
            if (!d.isDirectory()) {
                FileInputStream fis = new FileInputStream(d);
                ParserModel model = new ParserModel((InputStream)fis);
                this.parser = new Parser(model, 20, 0.95);
            } else {
                File f = new File(d, "build.bin.gz");
                buildModel = new SuffixSensitiveGISModelReader(f).getModel();
                f = new File(d, "check.bin.gz");
                checkModel = new SuffixSensitiveGISModelReader(f).getModel();
                f = new File(d, "pos.model.bin");
                AbstractModel posModel = new SuffixSensitiveGISModelReader(f).getModel();
                if (this.useTagDictionary) {
                    File td = new File(d, "tagdict");
                    POSDictionary tagDictionary = new POSDictionary(td.getAbsolutePath());
                    posTagger = new POSTaggerME(posModel, (TagDictionary)tagDictionary);
                } else {
                    Dictionary dictionary = null;
                    posTagger = new POSTaggerME(posModel, dictionary);
                }
                f = new File(d, "chunk.bin.gz");
                AbstractModel chunkModel = new SuffixSensitiveGISModelReader(f).getModel();
                chunker = new ChunkerME((MaxentModel)chunkModel);
                FileReader fr = new FileReader(new File(d, "head_rules"));
                headRules = new HeadRules((Reader)fr);
                this.parser = new Parser((MaxentModel)buildModel, (MaxentModel)checkModel, (POSTagger)posTagger, (Chunker)chunker, (opennlp.tools.parser.HeadRules)headRules);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getParseString(FSIterator tokens) {
        return this.parseStr;
    }

    @Override
    public void createAnnotations(JCas jcas) {
        String docId = DocumentIDAnnotationUtil.getDocumentID((JCas)jcas);
        this.logger.info((Object)("Started processing: " + docId));
        FSIterator iterator = jcas.getAnnotationIndex(Sentence.type).iterator();
        HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
        Parse parse = null;
        while (iterator.hasNext()) {
            Sentence sentAnnot = (Sentence)iterator.next();
            if (sentAnnot.getCoveredText().length() == 0) continue;
            indexMap.clear();
            FSArray termArray = this.getTerminals(jcas, sentAnnot);
            String sentStr = this.getSentence(termArray, indexMap);
            StringBuffer parseBuff = new StringBuffer();
            if (sentStr.length() == 0) {
                parseBuff.append("");
                parse = null;
            } else {
                parse = ParserTool.parseLine((String)sentStr, (opennlp.tools.parser.Parser)this.parser, (int)1)[0];
                parse.show(parseBuff);
            }
            this.parseStr = parseBuff.toString();
            TopTreebankNode top = new TopTreebankNode(jcas, sentAnnot.getBegin(), sentAnnot.getEnd());
            top.setTreebankParse(parseBuff.toString());
            top.setTerminals(termArray);
            top.setParent(null);
            if (parse == null) continue;
            this.recursivelyCreateStructure(jcas, (TreebankNode)top, parse, top, indexMap);
        }
        this.logger.info((Object)("Done parsing: " + docId));
    }

    private void recursivelyCreateStructure(JCas jcas, TreebankNode parent, Parse parse, TopTreebankNode root, Map<Integer, Integer> imap) {
        String[] typeParts = parse.getType().split("-");
        parent.setNodeType(typeParts[0]);
        parent.setNodeValue(typeParts[0]);
        parent.setLeaf(parse.getChildCount() == 0);
        StringArray tags = new StringArray(jcas, typeParts.length - 1);
        for (int i = 1; i < typeParts.length; ++i) {
            tags.set(i - 1, typeParts[i]);
        }
        parent.setNodeTags(tags);
        parent.setHeadIndex(parse.getHeadIndex());
        Parse[] subtrees = parse.getChildren();
        FSArray children = new FSArray(jcas, subtrees.length);
        for (int i = 0; i < subtrees.length; ++i) {
            Parse subtree = subtrees[i];
            Span span = subtree.getSpan();
            if (subtree.getChildCount() > 0) {
                try {
                    TreebankNode child = new TreebankNode(jcas, root.getBegin() + imap.get(span.getStart()), root.getBegin() + imap.get(span.getEnd()));
                    child.setParent(parent);
                    children.set(i, (FeatureStructure)child);
                    this.recursivelyCreateStructure(jcas, child, subtree, root, imap);
                }
                catch (NullPointerException e) {
                    System.err.println("MaxentParserWrapper Error: " + e);
                }
                continue;
            }
            TerminalTreebankNode term = root.getTerminals(subtree.getHeadIndex());
            children.set(i, (FeatureStructure)term);
            term.setParent(parent);
        }
        parent.setChildren(children);
        parent.addToIndexes();
    }

    private String getSentence(FSArray termArray, Map<Integer, Integer> imap) {
        StringBuffer sent = new StringBuffer();
        int offset = 0;
        for (int i = 0; i < termArray.size(); ++i) {
            TerminalTreebankNode ttn = (TerminalTreebankNode)termArray.get(i);
            String word = ttn.getNodeType();
            word = word.replaceAll("\\s", "");
            if (i == 0) {
                offset = ttn.getBegin();
            } else {
                if (word.length() == 0) continue;
                sent.append(" ");
            }
            sent.append(word);
            imap.put(sent.length() - word.length(), ttn.getBegin() - offset);
            imap.put(sent.length(), ttn.getEnd() - offset);
        }
        return sent.toString();
    }

    private FSArray getTerminals(JCas jcas, Sentence sent) {
        ArrayList<BaseToken> wordList = new ArrayList<BaseToken>();
        FSIterator iterator = jcas.getAnnotationIndex(BaseToken.type).subiterator((AnnotationFS)sent);
        while (iterator.hasNext()) {
            BaseToken w = (BaseToken)iterator.next();
            if (w instanceof NewlineToken) continue;
            wordList.add(w);
        }
        FSArray terms = new FSArray(jcas, wordList.size());
        for (int i = 0; i < wordList.size(); ++i) {
            BaseToken w = (BaseToken)wordList.get(i);
            TerminalTreebankNode ttn = new TerminalTreebankNode(jcas, w.getBegin(), w.getEnd());
            ttn.setChildren(null);
            ttn.setIndex(i);
            ttn.setTokenIndex(i);
            ttn.setLeaf(true);
            ttn.setNodeTags(null);
            if (w instanceof PunctuationToken) {
                String tokStr = w.getCoveredText();
                if (tokStr.equals("(") || tokStr.equals("[")) {
                    ttn.setNodeType("-LRB-");
                } else if (tokStr.equals(")") || tokStr.equals("]")) {
                    ttn.setNodeType("-RRB-");
                } else if (tokStr.equals("{")) {
                    ttn.setNodeType("-LCB-");
                } else if (tokStr.equals("}")) {
                    ttn.setNodeType("-RCB-");
                } else {
                    ttn.setNodeType(w.getCoveredText());
                }
            } else {
                ttn.setNodeType(w.getCoveredText());
            }
            ttn.setNodeValue(ttn.getNodeType());
            ttn.addToIndexes();
            terms.set(i, (FeatureStructure)ttn);
        }
        return terms;
    }
}

