/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.constituency.parser.util;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.parser.Parse;
import org.apache.ctakes.typesystem.type.syntax.TopTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.utils.tree.SimpleTree;

public class TreeUtils {
    public static List<TreebankNode> getNodeList(TopTreebankNode tree) {
        ArrayList<TreebankNode> list = new ArrayList<TreebankNode>();
        list.add((TreebankNode)tree);
        for (int ind = 0; ind < list.size(); ++ind) {
            TreebankNode cur = list.get(ind);
            for (int i = 0; i < cur.getChildren().size(); ++i) {
                list.add(cur.getChildren(i));
            }
        }
        return list;
    }

    public static List<Parse> getNodeList(Parse tree) {
        ArrayList<Parse> list = new ArrayList<Parse>();
        list.add(tree);
        for (int ind = 0; ind < list.size(); ++ind) {
            Parse cur = list.get(ind);
            Parse[] children = cur.getChildren();
            for (int i = 0; i < children.length; ++i) {
                list.add(children[i]);
            }
        }
        return list;
    }

    public static String tree2str(TreebankNode pathTree) {
        StringBuffer buff = new StringBuffer();
        buff.append("(");
        try {
            buff.append(pathTree.getNodeType());
        }
        catch (Exception e) {
            System.err.println("Caught NPE");
        }
        if (pathTree.getChildren().size() == 1 && pathTree.getChildren(0).getLeaf()) {
            buff.append(" ");
            buff.append(pathTree.getChildren(0).getNodeType());
        } else {
            for (int i = 0; i < pathTree.getChildren().size(); ++i) {
                buff.append(" ");
                buff.append(TreeUtils.tree2str(pathTree.getChildren(i)));
            }
        }
        buff.append(")");
        return buff.toString();
    }

    public static boolean contains(SimpleTree node, SimpleTree frag) {
        if (TreeUtils.fragmentMatch(node, frag)) {
            return true;
        }
        for (int i = 0; i < node.children.size(); ++i) {
            if (!TreeUtils.contains((SimpleTree)node.children.get(i), frag)) continue;
            return true;
        }
        return false;
    }

    private static boolean fragmentMatch(SimpleTree node, SimpleTree frag) {
        boolean same = false;
        if (node.cat.equals(frag.cat) && (frag.children.size() == 0 || node.children.size() == frag.children.size())) {
            same = true;
            for (int i = 0; i < frag.children.size(); ++i) {
                if (TreeUtils.fragmentMatch((SimpleTree)node.children.get(i), (SimpleTree)frag.children.get(i))) continue;
                same = false;
                break;
            }
        }
        return same;
    }
}

