/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.constituency.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.parser.chunking.Parser;
import org.apache.ctakes.constituency.parser.ParserWrapper;
import org.apache.ctakes.constituency.parser.util.TreeUtils;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.typesystem.type.syntax.TopTreebankNode;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;

public class MaxentParserWrapper
implements ParserWrapper {
    Parser parser = null;
    private String parseStr = "";
    Logger logger = Logger.getLogger((String)this.getClass().getName());
    private boolean usePos;

    public MaxentParserWrapper(String dataDir) {
        this(dataDir, false);
    }

    public MaxentParserWrapper(String dataDir, boolean usePos) {
        try {
            File d = new File(dataDir);
            this.usePos = usePos;
            if (!d.isDirectory()) {
                FileInputStream fis = new FileInputStream(d);
                ParserModel model = new ParserModel((InputStream)fis);
                this.parser = new Parser(model, 20, 0.95);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getParseString(FSIterator tokens) {
        return this.parseStr;
    }

    @Override
    public void createAnnotations(JCas jcas) throws AnalysisEngineProcessException {
        String docId = DocumentIDAnnotationUtil.getDocumentID((JCas)jcas);
        this.logger.info((Object)("Started processing: " + docId));
        FSIterator iterator = jcas.getAnnotationIndex(Sentence.type).iterator();
        Parse parse = null;
        while (iterator.hasNext()) {
            Sentence sentAnnot = (Sentence)iterator.next();
            if (sentAnnot.getCoveredText().length() == 0) continue;
            FSArray termArray = TreeUtils.getTerminals(jcas, sentAnnot);
            Parse inputTokens = TreeUtils.ctakesTokensToOpennlpTokens(sentAnnot, termArray);
            String sentStr = TreeUtils.getSentence(termArray);
            parse = sentStr.length() == 0 ? null : this.parser.parse(inputTokens);
            TopTreebankNode top = TreeUtils.buildAlignedTree(jcas, parse, sentAnnot);
            top.addToIndexes();
        }
        this.logger.info((Object)("Done parsing: " + docId));
    }
}

