/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.net.URI;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.FormAuthorizationResponse;
import org.apache.cxf.rs.security.oauth2.common.OAuthAuthorizationData;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.OAuthRedirectionState;
import org.apache.cxf.rs.security.oauth2.common.OOBAuthorizationResponse;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeRegistration;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.AuthorizationCodeResponseFilter;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.provider.OOBResponseDeliverer;
import org.apache.cxf.rs.security.oauth2.services.RedirectionBasedGrantService;

@Path(value="/authorize")
public class AuthorizationCodeGrantService
extends RedirectionBasedGrantService {
    private static final long RECOMMENDED_CODE_EXPIRY_TIME_SECS = 600L;
    private boolean canSupportPublicClients;
    private boolean canSupportEmptyRedirectForPrivateClients;
    private OOBResponseDeliverer oobDeliverer;
    private AuthorizationCodeResponseFilter codeResponseFilter;

    public AuthorizationCodeGrantService() {
        super("code", "authorization_code");
    }

    @Override
    protected OAuthAuthorizationData createAuthorizationData(Client client, MultivaluedMap<String, String> params, String redirectUri, UserSubject subject, List<OAuthPermission> requestedPerms, List<OAuthPermission> alreadyAuthorizedPerms, boolean authorizationCanBeSkipped) {
        OAuthAuthorizationData data = super.createAuthorizationData(client, params, redirectUri, subject, requestedPerms, alreadyAuthorizedPerms, authorizationCanBeSkipped);
        AuthorizationCodeGrantService.setCodeChallenge(data, params);
        return data;
    }

    @Override
    protected OAuthRedirectionState recreateRedirectionStateFromParams(MultivaluedMap<String, String> params) {
        OAuthRedirectionState state = super.recreateRedirectionStateFromParams(params);
        AuthorizationCodeGrantService.setCodeChallenge(state, params);
        return state;
    }

    private static void setCodeChallenge(OAuthRedirectionState data, MultivaluedMap<String, String> params) {
        data.setClientCodeChallenge((String)params.getFirst((Object)"code_challenge"));
    }

    @Override
    protected Response createGrant(OAuthRedirectionState state, Client client, List<String> requestedScope, List<String> approvedScope, UserSubject userSubject, ServerAccessToken preauthorizedToken) {
        ServerAuthorizationCodeGrant grant = null;
        try {
            grant = this.getGrantRepresentation(state, client, requestedScope, approvedScope, userSubject, preauthorizedToken);
        }
        catch (OAuthServiceException ex) {
            return this.createErrorResponse(state.getState(), state.getRedirectUri(), "access_denied");
        }
        String grantCode = this.processCodeGrant(client, grant.getCode(), grant.getSubject());
        if (state.getRedirectUri() == null) {
            OOBAuthorizationResponse bean = new OOBAuthorizationResponse();
            bean.setClientId(client.getClientId());
            bean.setClientDescription(client.getApplicationDescription());
            bean.setAuthorizationCode(grantCode);
            bean.setUserId(userSubject.getLogin());
            bean.setExpiresIn(grant.getExpiresIn());
            return this.deliverOOBResponse(bean);
        }
        if (this.isFormResponse(state)) {
            FormAuthorizationResponse bean = new FormAuthorizationResponse();
            bean.setAuthorizationCode(grantCode);
            bean.setExpiresIn(grant.getExpiresIn());
            bean.setState(state.getState());
            bean.setRedirectUri(state.getRedirectUri());
            return this.createHtmlResponse(bean);
        }
        UriBuilder ub = this.getRedirectUriBuilder(state.getState(), state.getRedirectUri());
        ub.queryParam("code", new Object[]{grantCode});
        return Response.seeOther((URI)ub.build(new Object[0])).build();
    }

    public ServerAuthorizationCodeGrant getGrantRepresentation(OAuthRedirectionState state, Client client, List<String> requestedScope, List<String> approvedScope, UserSubject userSubject, ServerAccessToken preauthorizedToken) {
        AuthorizationCodeRegistration codeReg = this.createCodeRegistration(state, client, requestedScope, approvedScope, userSubject, preauthorizedToken);
        ServerAuthorizationCodeGrant grant = ((AuthorizationCodeDataProvider)this.getDataProvider()).createCodeGrant(codeReg);
        if (grant.getExpiresIn() > 600L) {
            LOG.warning("Code expiry time exceeds 10 minutes");
        }
        return grant;
    }

    protected AuthorizationCodeRegistration createCodeRegistration(OAuthRedirectionState state, Client client, List<String> requestedScope, List<String> approvedScope, UserSubject userSubject, ServerAccessToken preauthorizedToken) {
        AuthorizationCodeRegistration codeReg = new AuthorizationCodeRegistration();
        codeReg.setPreauthorizedTokenAvailable(preauthorizedToken != null);
        codeReg.setClient(client);
        codeReg.setRedirectUri(state.getRedirectUri());
        codeReg.setRequestedScope(requestedScope);
        codeReg.setResponseType(state.getResponseType());
        codeReg.setApprovedScope(this.getApprovedScope(requestedScope, approvedScope));
        codeReg.setSubject(userSubject);
        codeReg.setAudience(state.getAudience());
        codeReg.setNonce(state.getNonce());
        codeReg.setClientCodeChallenge(state.getClientCodeChallenge());
        codeReg.getExtraProperties().putAll(state.getExtraProperties());
        return codeReg;
    }

    protected String processCodeGrant(Client client, String code, UserSubject endUser) {
        if (this.codeResponseFilter != null) {
            return this.codeResponseFilter.process(client, code, endUser);
        }
        return code;
    }

    protected Response deliverOOBResponse(OOBAuthorizationResponse response) {
        if (this.oobDeliverer != null) {
            return this.oobDeliverer.deliver(response);
        }
        return this.createHtmlResponse(response);
    }

    @Override
    protected Response createErrorResponse(String state, String redirectUri, String error) {
        if (redirectUri == null) {
            return Response.status((int)401).entity((Object)error).build();
        }
        UriBuilder ub = this.getRedirectUriBuilder(state, redirectUri);
        ub.queryParam("error", new Object[]{error});
        return Response.seeOther((URI)ub.build(new Object[0])).build();
    }

    protected UriBuilder getRedirectUriBuilder(String state, String redirectUri) {
        UriBuilder ub = UriBuilder.fromUri((String)redirectUri);
        if (state != null) {
            ub.queryParam("state", new Object[]{state});
        }
        return ub;
    }

    @Override
    protected boolean canSupportPublicClient(Client c) {
        return this.canSupportPublicClients && !c.isConfidential() && c.getClientSecret() == null;
    }

    @Override
    protected boolean canRedirectUriBeEmpty(Client c) {
        return (c.isConfidential() && this.canSupportEmptyRedirectForPrivateClients || this.canSupportPublicClient(c)) && c.getRedirectUris().isEmpty();
    }

    public void setCanSupportPublicClients(boolean support) {
        this.canSupportPublicClients = support;
    }

    public void setCodeResponseFilter(AuthorizationCodeResponseFilter filter) {
        this.codeResponseFilter = filter;
    }

    public void setCanSupportEmptyRedirectForPrivateClients(boolean canSupportEmptyRedirectForPrivateClients) {
        this.canSupportEmptyRedirectForPrivateClients = canSupportEmptyRedirectForPrivateClients;
    }
}

