/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthAuthorizationData;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.OAuthRedirectionState;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.AuthorizationRequestFilter;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.provider.ResourceOwnerNameProvider;
import org.apache.cxf.rs.security.oauth2.provider.SessionAuthenticityTokenProvider;
import org.apache.cxf.rs.security.oauth2.provider.SubjectCreator;
import org.apache.cxf.rs.security.oauth2.services.AbstractOAuthService;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.security.SecurityContext;

public abstract class RedirectionBasedGrantService
extends AbstractOAuthService {
    private static final String AUTHORIZATION_REQUEST_PARAMETERS = "authorization.request.parameters";
    private static final String PREAUTHORIZED_TOKEN_KEY = "preauthorized.token.key";
    private Set<String> supportedResponseTypes;
    private String supportedGrantType;
    private boolean useAllClientScopes;
    private boolean partialMatchScopeValidation;
    private boolean useRegisteredRedirectUriIfPossible = true;
    private SessionAuthenticityTokenProvider sessionAuthenticityTokenProvider;
    private SubjectCreator subjectCreator;
    private ResourceOwnerNameProvider resourceOwnerNameProvider;
    private int maxDefaultSessionInterval;
    private boolean matchRedirectUriWithApplicationUri;
    private boolean hidePreauthorizedScopesInForm;
    private AuthorizationRequestFilter authorizationFilter;
    private List<String> scopesRequiringNoConsent;
    private boolean supportSinglePageApplications = true;
    private boolean revokePreauthorizedTokenOnApproval = true;

    protected RedirectionBasedGrantService(String supportedResponseType, String supportedGrantType) {
        this(Collections.singleton(supportedResponseType), supportedGrantType);
    }

    protected RedirectionBasedGrantService(Set<String> supportedResponseTypes, String supportedGrantType) {
        this.supportedResponseTypes = supportedResponseTypes;
        this.supportedGrantType = supportedGrantType;
    }

    @GET
    @Produces(value={"application/xhtml+xml", "text/html", "application/xml", "application/json"})
    public Response authorize() {
        MultivaluedMap<String, String> params = this.getQueryParameters();
        return this.startAuthorization(params);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/xhtml+xml", "text/html", "application/xml", "application/json"})
    public Response authorizePost(MultivaluedMap<String, String> params) {
        return this.startAuthorization(params);
    }

    @GET
    @Path(value="/decision")
    public Response authorizeDecision() {
        MultivaluedMap<String, String> params = this.getQueryParameters();
        return this.completeAuthorization(params);
    }

    @POST
    @Path(value="/decision")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response authorizeDecisionForm(MultivaluedMap<String, String> params) {
        return this.completeAuthorization(params);
    }

    protected Response startAuthorization(MultivaluedMap<String, String> params) {
        SecurityContext sc = this.getAndValidateSecurityContext(params);
        Client client = this.getClient((String)params.getFirst((Object)"client_id"), params);
        UserSubject userSubject = this.createUserSubject(sc, params);
        if (this.authorizationFilter != null) {
            params = this.authorizationFilter.process(params, userSubject, client);
        }
        String redirectUri = this.validateRedirectUri(client, (String)params.getFirst((Object)"redirect_uri"));
        return this.startAuthorization(params, userSubject, client, redirectUri);
    }

    protected Response startAuthorization(MultivaluedMap<String, String> params, UserSubject userSubject, Client client, String redirectUri) {
        if (!OAuthUtils.isGrantSupportedForClient(client, this.canSupportPublicClient(client), this.supportedGrantType)) {
            LOG.fine("The grant type is not supported");
            return this.createErrorResponse(params, redirectUri, "unauthorized_client");
        }
        String responseType = (String)params.getFirst((Object)"response_type");
        if (responseType == null || !this.getSupportedResponseTypes().contains(responseType)) {
            LOG.fine("The response type is null or not supported");
            return this.createErrorResponse(params, redirectUri, "unsupported_response_type");
        }
        String providedScope = (String)params.getFirst((Object)"scope");
        List<String> requestedScope = null;
        List<OAuthPermission> requestedPermissions = null;
        try {
            requestedScope = OAuthUtils.getRequestedScopes(client, providedScope, this.useAllClientScopes, this.partialMatchScopeValidation);
            requestedPermissions = this.getDataProvider().convertScopeToPermissions(client, requestedScope);
        }
        catch (OAuthServiceException ex) {
            LOG.log(Level.FINE, "Error processing scopes", ex);
            return this.createErrorResponse(params, redirectUri, "invalid_scope");
        }
        String clientAudience = (String)params.getFirst((Object)"audience");
        if (!OAuthUtils.validateAudience(clientAudience, client.getRegisteredAudiences())) {
            LOG.fine("Error validating audience parameter");
            return this.createErrorResponse(params, redirectUri, "invalid_request");
        }
        ServerAccessToken preAuthorizedToken = null;
        if (this.canAccessTokenBeReturned(responseType)) {
            preAuthorizedToken = this.getDataProvider().getPreauthorizedToken(client, requestedScope, userSubject, this.supportedGrantType);
        }
        List<OAuthPermission> alreadyAuthorizedPerms = null;
        boolean preAuthorizationComplete = false;
        if (preAuthorizedToken != null) {
            alreadyAuthorizedPerms = preAuthorizedToken.getScopes();
            preAuthorizationComplete = OAuthUtils.convertPermissionsToScopeList(alreadyAuthorizedPerms).containsAll(requestedScope);
        }
        Response finalResponse = null;
        try {
            boolean authorizationCanBeSkipped = preAuthorizationComplete || this.canAuthorizationBeSkipped(params, client, userSubject, requestedScope, requestedPermissions);
            OAuthAuthorizationData data = this.createAuthorizationData(client, params, redirectUri, userSubject, requestedPermissions, alreadyAuthorizedPerms, authorizationCanBeSkipped);
            if (authorizationCanBeSkipped) {
                this.getMessageContext().put((Object)AUTHORIZATION_REQUEST_PARAMETERS, params);
                List<OAuthPermission> approvedScopes = preAuthorizationComplete ? preAuthorizedToken.getScopes() : requestedPermissions;
                finalResponse = this.createGrant(data, client, requestedScope, OAuthUtils.convertPermissionsToScopeList(approvedScopes), userSubject, preAuthorizedToken);
            } else {
                if (preAuthorizedToken != null) {
                    data.setPreauthorizedTokenKey(preAuthorizedToken.getTokenKey());
                }
                finalResponse = Response.ok((Object)data).build();
            }
        }
        catch (OAuthServiceException ex) {
            finalResponse = this.createErrorResponse(params, redirectUri, ex.getError().getError());
        }
        return finalResponse;
    }

    public Set<String> getSupportedResponseTypes() {
        return this.supportedResponseTypes;
    }

    protected boolean canAuthorizationBeSkipped(MultivaluedMap<String, String> params, Client client, UserSubject userSubject, List<String> requestedScope, List<OAuthPermission> permissions) {
        return this.noConsentForRequestedScopes(params, client, userSubject, requestedScope, permissions);
    }

    protected boolean noConsentForRequestedScopes(MultivaluedMap<String, String> params, Client client, UserSubject userSubject, List<String> requestedScope, List<OAuthPermission> permissions) {
        return this.scopesRequiringNoConsent != null && requestedScope != null && this.scopesRequiringNoConsent.containsAll(requestedScope);
    }

    protected OAuthAuthorizationData createAuthorizationData(Client client, MultivaluedMap<String, String> params, String redirectUri, UserSubject subject, List<OAuthPermission> requestedPerms, List<OAuthPermission> alreadyAuthorizedPerms, boolean authorizationCanBeSkipped) {
        OAuthAuthorizationData secData = new OAuthAuthorizationData();
        secData.setState((String)params.getFirst((Object)"state"));
        secData.setRedirectUri(redirectUri);
        secData.setAudience((String)params.getFirst((Object)"audience"));
        secData.setNonce((String)params.getFirst((Object)"nonce"));
        secData.setClientId(client.getClientId());
        secData.setResponseType((String)params.getFirst((Object)"response_type"));
        if (requestedPerms != null && !requestedPerms.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (OAuthPermission perm : requestedPerms) {
                builder.append(perm.getPermission() + " ");
            }
            secData.setProposedScope(builder.toString().trim());
        }
        if (!authorizationCanBeSkipped) {
            secData.setPermissions(requestedPerms);
            secData.setAlreadyAuthorizedPermissions(alreadyAuthorizedPerms);
            secData.setHidePreauthorizedScopesInForm(this.hidePreauthorizedScopesInForm);
            secData.setApplicationName(client.getApplicationName());
            secData.setApplicationWebUri(client.getApplicationWebUri());
            secData.setApplicationDescription(client.getApplicationDescription());
            secData.setApplicationLogoUri(client.getApplicationLogoUri());
            secData.setApplicationCertificates(client.getApplicationCertificates());
            Map<String, String> extraProperties = client.getProperties();
            secData.setExtraApplicationProperties(extraProperties);
            secData.setApplicationRegisteredDynamically(client.isRegisteredDynamically());
            secData.setSupportSinglePageApplications(this.supportSinglePageApplications);
            String replyTo = this.getMessageContext().getUriInfo().getAbsolutePathBuilder().path("decision").build(new Object[0]).toString();
            secData.setReplyTo(replyTo);
            this.personalizeData(secData, subject);
            this.addAuthenticityTokenToSession(secData, params, subject);
        }
        return secData;
    }

    protected OAuthRedirectionState recreateRedirectionStateFromSession(UserSubject subject, String sessionToken) {
        if (this.sessionAuthenticityTokenProvider != null) {
            return this.sessionAuthenticityTokenProvider.getSessionState(super.getMessageContext(), sessionToken, subject);
        }
        return null;
    }

    protected OAuthRedirectionState recreateRedirectionStateFromParams(MultivaluedMap<String, String> params) {
        OAuthRedirectionState state = new OAuthRedirectionState();
        state.setClientId((String)params.getFirst((Object)"client_id"));
        state.setRedirectUri((String)params.getFirst((Object)"redirect_uri"));
        state.setAudience((String)params.getFirst((Object)"audience"));
        state.setProposedScope((String)params.getFirst((Object)"scope"));
        state.setState((String)params.getFirst((Object)"state"));
        state.setNonce((String)params.getFirst((Object)"nonce"));
        state.setResponseType((String)params.getFirst((Object)"response_type"));
        return state;
    }

    protected void personalizeData(OAuthAuthorizationData data, UserSubject userSubject) {
        if (this.resourceOwnerNameProvider != null) {
            data.setEndUserName(this.resourceOwnerNameProvider.getName(userSubject));
        }
    }

    protected List<String> getApprovedScope(List<String> requestedScope, List<String> approvedScope) {
        if (StringUtils.isEmpty(approvedScope)) {
            return requestedScope;
        }
        return approvedScope;
    }

    protected Response completeAuthorization(MultivaluedMap<String, String> params) {
        String sessionToken;
        SecurityContext securityContext = this.getAndValidateSecurityContext(params);
        UserSubject userSubject = this.createUserSubject(securityContext, params);
        String sessionTokenParamName = (String)params.getFirst((Object)"session_authenticity_token_param_name");
        if (sessionTokenParamName == null) {
            sessionTokenParamName = "session_authenticity_token";
        }
        if ((sessionToken = (String)params.getFirst((Object)sessionTokenParamName)) == null || !this.compareRequestAndSessionTokens(sessionToken, params, userSubject)) {
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        OAuthRedirectionState state = this.recreateRedirectionStateFromSession(userSubject, sessionToken);
        if (state == null) {
            state = this.recreateRedirectionStateFromParams(params);
        }
        Client client = this.getClient(state.getClientId(), params);
        String redirectUri = this.validateRedirectUri(client, state.getRedirectUri());
        String decision = (String)params.getFirst((Object)"oauthDecision");
        boolean allow = "allow".equals(decision);
        if (!allow) {
            return this.createErrorResponse(params, redirectUri, "access_denied");
        }
        List<String> requestedScope = OAuthUtils.parseScope(state.getProposedScope());
        LinkedList<String> approvedScope = new LinkedList<String>();
        for (String rScope : requestedScope) {
            String param = (String)params.getFirst((Object)(rScope + "_status"));
            if (param == null || !"allow".equals(param)) continue;
            approvedScope.add(rScope);
        }
        if (!requestedScope.containsAll(approvedScope) || !OAuthUtils.validateScopes(requestedScope, client.getRegisteredScopes(), this.partialMatchScopeValidation)) {
            return this.createErrorResponse(params, redirectUri, "invalid_scope");
        }
        this.getMessageContext().put((Object)AUTHORIZATION_REQUEST_PARAMETERS, params);
        String preAuthorizedTokenKey = (String)params.getFirst((Object)PREAUTHORIZED_TOKEN_KEY);
        if (preAuthorizedTokenKey != null && this.isRevokePreauthorizedTokenOnApproval()) {
            this.getDataProvider().revokeToken(client, preAuthorizedTokenKey, "access_token");
        }
        return this.createGrant(state, client, requestedScope, approvedScope, userSubject, null);
    }

    public boolean isRevokePreauthorizedTokenOnApproval() {
        return this.revokePreauthorizedTokenOnApproval;
    }

    public void setRevokePreauthorizedTokenOnApproval(boolean revoke) {
        this.revokePreauthorizedTokenOnApproval = revoke;
    }

    public void setSessionAuthenticityTokenProvider(SessionAuthenticityTokenProvider sessionAuthenticityTokenProvider) {
        this.sessionAuthenticityTokenProvider = sessionAuthenticityTokenProvider;
    }

    public void setSubjectCreator(SubjectCreator creator) {
        this.subjectCreator = creator;
    }

    protected UserSubject createUserSubject(SecurityContext securityContext, MultivaluedMap<String, String> params) {
        UserSubject subject = null;
        if (this.subjectCreator != null && (subject = this.subjectCreator.createUserSubject(this.getMessageContext(), params)) != null) {
            return subject;
        }
        return OAuthUtils.createSubject(this.getMessageContext(), securityContext);
    }

    protected Response createErrorResponse(MultivaluedMap<String, String> params, String redirectUri, String error) {
        return this.createErrorResponse((String)params.getFirst((Object)"state"), redirectUri, error);
    }

    protected boolean canAccessTokenBeReturned(String responseType) {
        return true;
    }

    protected abstract Response createErrorResponse(String var1, String var2, String var3);

    protected abstract Response createGrant(OAuthRedirectionState var1, Client var2, List<String> var3, List<String> var4, UserSubject var5, ServerAccessToken var6);

    protected SecurityContext getAndValidateSecurityContext(MultivaluedMap<String, String> params) {
        SecurityContext securityContext = (SecurityContext)this.getMessageContext().get((Object)SecurityContext.class.getName());
        if (securityContext == null || securityContext.getUserPrincipal() == null) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
        this.checkTransportSecurity();
        return securityContext;
    }

    protected String validateRedirectUri(Client client, String redirectUri) {
        List<String> uris = client.getRedirectUris();
        if (redirectUri != null) {
            if (!uris.contains(redirectUri)) {
                this.reportInvalidRequestError("Client Redirect Uri is invalid");
            }
        } else if (uris.size() == 1 && this.useRegisteredRedirectUriIfPossible) {
            redirectUri = uris.get(0);
        }
        if (redirectUri == null && uris.isEmpty() && !this.canRedirectUriBeEmpty(client)) {
            this.reportInvalidRequestError("Client Redirect Uri is invalid");
        }
        if (redirectUri != null && this.matchRedirectUriWithApplicationUri && client.getApplicationWebUri() != null && !redirectUri.startsWith(client.getApplicationWebUri())) {
            this.reportInvalidRequestError("Client Redirect Uri is invalid");
        }
        return redirectUri;
    }

    private void addAuthenticityTokenToSession(OAuthAuthorizationData secData, MultivaluedMap<String, String> params, UserSubject subject) {
        String sessionToken = this.sessionAuthenticityTokenProvider != null ? this.sessionAuthenticityTokenProvider.createSessionToken(this.getMessageContext(), params, subject, secData) : OAuthUtils.setSessionToken(this.getMessageContext(), this.maxDefaultSessionInterval);
        secData.setAuthenticityToken(sessionToken);
    }

    private boolean compareRequestAndSessionTokens(String requestToken, MultivaluedMap<String, String> params, UserSubject subject) {
        String sessionToken = this.sessionAuthenticityTokenProvider != null ? this.sessionAuthenticityTokenProvider.removeSessionToken(this.getMessageContext(), params, subject) : OAuthUtils.getSessionToken(this.getMessageContext());
        if (StringUtils.isEmpty((String)sessionToken)) {
            return false;
        }
        return requestToken.equals(sessionToken);
    }

    protected Client getClient(String clientId, MultivaluedMap<String, String> params) {
        Client client;
        block3: {
            client = null;
            try {
                client = this.getValidClient(clientId, params);
            }
            catch (OAuthServiceException ex) {
                if (ex.getError() == null) break block3;
                this.reportInvalidRequestError(ex.getError(), null);
            }
        }
        if (client == null) {
            this.reportInvalidRequestError("Client ID is invalid", null);
        }
        return client;
    }

    protected Response createHtmlResponse(Object response) {
        return Response.ok((Object)response).type("text/html").build();
    }

    protected boolean isFormResponse(OAuthRedirectionState state) {
        return "form_post".equals(state.getExtraProperties().get("response_mode"));
    }

    protected String getSupportedGrantType() {
        return this.supportedGrantType;
    }

    public void setResourceOwnerNameProvider(ResourceOwnerNameProvider resourceOwnerNameProvider) {
        this.resourceOwnerNameProvider = resourceOwnerNameProvider;
    }

    public void setPartialMatchScopeValidation(boolean partialMatchScopeValidation) {
        this.partialMatchScopeValidation = partialMatchScopeValidation;
    }

    public void setUseAllClientScopes(boolean useAllClientScopes) {
        this.useAllClientScopes = useAllClientScopes;
    }

    public void setUseRegisteredRedirectUriIfPossible(boolean use) {
        this.useRegisteredRedirectUriIfPossible = use;
    }

    protected abstract boolean canSupportPublicClient(Client var1);

    protected abstract boolean canRedirectUriBeEmpty(Client var1);

    public void setMaxDefaultSessionInterval(int maxDefaultSessionInterval) {
        this.maxDefaultSessionInterval = maxDefaultSessionInterval;
    }

    public void setMatchRedirectUriWithApplicationUri(boolean matchRedirectUriWithApplicationUri) {
        this.matchRedirectUriWithApplicationUri = matchRedirectUriWithApplicationUri;
    }

    public void setHidePreauthorizedScopesInForm(boolean hidePreauthorizedScopesInForm) {
        this.hidePreauthorizedScopesInForm = hidePreauthorizedScopesInForm;
    }

    public void setAuthorizationFilter(AuthorizationRequestFilter authorizationFilter) {
        this.authorizationFilter = authorizationFilter;
    }

    public void setScopesRequiringNoConsent(List<String> scopesRequiringNoConsent) {
        this.scopesRequiringNoConsent = scopesRequiringNoConsent;
    }

    public void setSupportSinglePageApplications(boolean supportSinglePageApplications) {
        this.supportSinglePageApplications = supportSinglePageApplications;
    }
}

