/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.interfaces.ECPublicKey;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesWrapKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.EcdhHelper;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionProvider;

public class EcdhAesWrapKeyEncryptionAlgorithm
implements KeyEncryptionProvider {
    private static final Map<String, String> ECDH_AES_MAP = new HashMap<String, String>();
    private final KeyAlgorithm keyAlgo;
    private final EcdhHelper helper;

    public EcdhAesWrapKeyEncryptionAlgorithm(ECPublicKey peerPublicKey, KeyAlgorithm keyAlgo) {
        this(peerPublicKey, "P-256", keyAlgo);
    }

    public EcdhAesWrapKeyEncryptionAlgorithm(ECPublicKey peerPublicKey, String curve, KeyAlgorithm keyAlgo) {
        this(peerPublicKey, curve, null, null, keyAlgo, ContentAlgorithm.A128GCM);
    }

    public EcdhAesWrapKeyEncryptionAlgorithm(ECPublicKey peerPublicKey, String curve, KeyAlgorithm keyAlgo, ContentAlgorithm ctAlgo) {
        this(peerPublicKey, curve, null, null, keyAlgo, ctAlgo);
    }

    public EcdhAesWrapKeyEncryptionAlgorithm(ECPublicKey peerPublicKey, String curve, String apuString, String apvString, KeyAlgorithm keyAlgo, ContentAlgorithm ctAlgo) {
        this.keyAlgo = keyAlgo;
        this.helper = new EcdhHelper(peerPublicKey, curve, apuString, apvString, ctAlgo.getJwaName());
    }

    @Override
    public byte[] getEncryptedContentEncryptionKey(JweHeaders headers, byte[] cek) {
        byte[] derivedKey = this.helper.getDerivedKey(headers);
        AesWrapKeyEncryptionAlgorithm aesWrap = new AesWrapKeyEncryptionAlgorithm(derivedKey, this.keyAlgo){

            @Override
            protected void checkAlgorithms(JweHeaders headers) {
            }

            @Override
            protected String getKeyEncryptionAlgoJava(JweHeaders headers) {
                return "AESWrap";
            }
        };
        return aesWrap.getEncryptedContentEncryptionKey(headers, cek);
    }

    @Override
    public KeyAlgorithm getAlgorithm() {
        return this.keyAlgo;
    }

    static {
        ECDH_AES_MAP.put(KeyAlgorithm.ECDH_ES_A128KW.getJwaName(), KeyAlgorithm.A128KW.getJwaName());
        ECDH_AES_MAP.put(KeyAlgorithm.ECDH_ES_A192KW.getJwaName(), KeyAlgorithm.A192KW.getJwaName());
        ECDH_AES_MAP.put(KeyAlgorithm.ECDH_ES_A256KW.getJwaName(), KeyAlgorithm.A256KW.getJwaName());
    }
}

