/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.stats;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.terracotta.management.model.stats.DelegatingSample;
import org.terracotta.management.model.stats.Sample;
import org.terracotta.management.model.stats.Statistic;
import org.terracotta.management.model.stats.StatisticType;

public class DelegatingStatistic<T extends Serializable>
implements Statistic<T> {
    private static final long serialVersionUID = 1L;
    private final org.ehcache.shadow.org.terracotta.statistics.registry.Statistic<T> delegate;

    public DelegatingStatistic(org.ehcache.shadow.org.terracotta.statistics.registry.Statistic<T> statistic) {
        this.delegate = statistic;
    }

    public DelegatingStatistic(StatisticType type) {
        this.delegate = new org.ehcache.shadow.org.terracotta.statistics.registry.Statistic(StatisticType.convert(type));
    }

    public DelegatingStatistic(StatisticType type, Sample<T> sample) {
        this.delegate = new org.ehcache.shadow.org.terracotta.statistics.registry.Statistic<T>(StatisticType.convert(type), new org.ehcache.shadow.org.terracotta.statistics.Sample<T>(sample.getTimestamp(), sample.getSample()));
    }

    public DelegatingStatistic(StatisticType type, List<Sample<T>> samples) {
        this.delegate = new org.ehcache.shadow.org.terracotta.statistics.registry.Statistic(StatisticType.convert(type), DelegatingStatistic.list(samples));
    }

    @Override
    public StatisticType getType() {
        return StatisticType.convert(this.delegate.getType());
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public List<Sample<T>> getSamples() {
        return this.delegate.getSamples().stream().map(x -> new DelegatingSample(x.getTimestamp(), x.getSample())).collect(Collectors.toList());
    }

    @Override
    public Optional<T> getLatestSampleValue() {
        return this.delegate.getLatestSampleValue();
    }

    @Override
    public Optional<Sample<T>> getLatestSample() {
        return this.delegate.getLatestSample().map(x -> new DelegatingSample(x.getTimestamp(), x.getSample()));
    }

    private static <R extends Serializable> List<org.ehcache.shadow.org.terracotta.statistics.Sample<R>> list(List<Sample<R>> samples) {
        return samples.stream().map(x -> new org.ehcache.shadow.org.terracotta.statistics.Sample(x.getTimestamp(), x.getSample())).collect(Collectors.toList());
    }

    public static <U extends Serializable> org.ehcache.shadow.org.terracotta.statistics.registry.Statistic<U> convertStats(Statistic<U> statistic) {
        return new org.ehcache.shadow.org.terracotta.statistics.registry.Statistic(StatisticType.convert(statistic.getType()), DelegatingStatistic.list(statistic.getSamples()));
    }
}

