/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.ArgType;
import org.apache.cxf.binding.corba.wsdl.CorbaConstants;
import org.apache.cxf.binding.corba.wsdl.CorbaType;
import org.apache.cxf.binding.corba.wsdl.ModeType;
import org.apache.cxf.binding.corba.wsdl.OperationType;
import org.apache.cxf.binding.corba.wsdl.ParamType;
import org.apache.cxf.tools.corba.common.ReferenceConstants;
import org.apache.cxf.tools.corba.processors.idl.AttributeDeferredAction;
import org.apache.cxf.tools.corba.processors.idl.ParamTypeSpecVisitor;
import org.apache.cxf.tools.corba.processors.idl.Scope;
import org.apache.cxf.tools.corba.processors.idl.TypesUtils;
import org.apache.cxf.tools.corba.processors.idl.VisitorBase;
import org.apache.cxf.tools.corba.processors.idl.WSDLASTVisitor;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;

public class AttributeVisitor
extends VisitorBase {
    private static Map<String, String> duplicateTypeTrackerMap = new HashMap<String, String>();
    private static final String GETTER_PREFIX = "_get_";
    private static final String SETTER_PREFIX = "_set_";
    private static final String RESULT_POSTFIX = "Result";
    private static final String RESPONSE_POSTFIX = "Response";
    private static final String PART_NAME = "parameters";
    private static final String PARAM_NAME = "_arg";
    private static final String RETURN_PARAM_NAME = "return";
    private ExtensionRegistry extReg;
    private PortType portType;
    private Binding binding;

    public AttributeVisitor(Scope scope, Definition defn, XmlSchema schemaRef, WSDLASTVisitor wsdlVisitor, PortType wsdlPortType, Binding wsdlBinding) {
        super(scope, defn, schemaRef, wsdlVisitor);
        this.extReg = this.definition.getExtensionRegistry();
        this.portType = wsdlPortType;
        this.binding = wsdlBinding;
    }

    public static boolean accept(AST node) {
        return node.getType() == 79 || node.getType() == 80;
    }

    @Override
    public void visit(AST attributeNode) {
        AST node = attributeNode.getFirstChild();
        AST readonlyNode = null;
        AST typeNode = null;
        AST nameNode = null;
        if (node.getType() == 79) {
            readonlyNode = node;
            typeNode = readonlyNode.getNextSibling();
        } else {
            typeNode = node;
        }
        for (nameNode = TypesUtils.getCorbaTypeNameNode(typeNode); nameNode != null; nameNode = nameNode.getNextSibling()) {
            this.generateGetter(typeNode, nameNode);
            if (readonlyNode != null) continue;
            this.generateSetter(typeNode, nameNode);
        }
    }

    private void generateGetter(AST typeNode, AST nameNode) {
        XmlSchemaElement inParameters = this.generateWrappedDocElement(null, GETTER_PREFIX + nameNode.toString(), PARAM_NAME);
        XmlSchemaElement outParameters = this.generateWrappedDocElement(typeNode, GETTER_PREFIX + nameNode.toString() + RESULT_POSTFIX, RETURN_PARAM_NAME);
        Message inMsg = this.generateMessage(inParameters, GETTER_PREFIX + nameNode.toString());
        Message outMsg = this.generateMessage(outParameters, GETTER_PREFIX + nameNode.toString() + RESPONSE_POSTFIX);
        String name = GETTER_PREFIX + nameNode.toString();
        Operation op = this.generateOperation(name, inMsg, outMsg);
        ArgType corbaReturn = this.generateCorbaReturnParam(typeNode);
        OperationType corbaOp = this.generateCorbaOperation(op, null, corbaReturn);
        this.generateCorbaBindingOperation(this.binding, op, corbaOp);
    }

    private void generateSetter(AST typeNode, AST nameNode) {
        XmlSchemaElement inParameters = this.generateWrappedDocElement(typeNode, SETTER_PREFIX + nameNode.toString(), PARAM_NAME);
        XmlSchemaElement outParameters = this.generateWrappedDocElement(null, SETTER_PREFIX + nameNode.toString() + RESULT_POSTFIX, RETURN_PARAM_NAME);
        Message inMsg = this.generateMessage(inParameters, SETTER_PREFIX + nameNode.toString());
        Message outMsg = this.generateMessage(outParameters, SETTER_PREFIX + nameNode.toString() + RESPONSE_POSTFIX);
        String name = SETTER_PREFIX + nameNode.toString();
        Operation op = this.generateOperation(name, inMsg, outMsg);
        ParamType corbaParam = this.generateCorbaParam(typeNode);
        OperationType corbaOp = this.generateCorbaOperation(op, corbaParam, null);
        this.generateCorbaBindingOperation(this.binding, op, corbaOp);
    }

    private XmlSchemaElement generateWrappedDocElement(AST typeNode, String name, String paramName) {
        XmlSchemaElement element = new XmlSchemaElement(this.schema, false);
        if (typeNode != null) {
            ParamTypeSpecVisitor visitor = new ParamTypeSpecVisitor(this.getScope(), this.definition, this.schema, this.wsdlVisitor);
            visitor.visit(typeNode);
            XmlSchemaType stype = visitor.getSchemaType();
            Scope fqName = visitor.getFullyQualifiedName();
            if (stype != null) {
                element.setSchemaTypeName(stype.getQName());
                if (stype.getQName().equals(ReferenceConstants.WSADDRESSING_TYPE)) {
                    element.setNillable(true);
                }
            } else {
                this.wsdlVisitor.getDeferredActions().add(fqName, new AttributeDeferredAction(element));
            }
            element.setName(paramName);
        }
        XmlSchemaSequence sequence = new XmlSchemaSequence();
        if (typeNode != null) {
            sequence.getItems().add(element);
        }
        XmlSchemaComplexType complex = new XmlSchemaComplexType(this.schema, false);
        complex.setParticle((XmlSchemaParticle)sequence);
        QName qName = new QName(this.definition.getTargetNamespace(), name);
        XmlSchemaElement result = new XmlSchemaElement(this.schema, true);
        result.setSchemaType((XmlSchemaType)complex);
        if (duplicateTypeTrackerMap.containsKey(qName.toString())) {
            result.setName(this.getScope().toString() + "." + name);
            qName = new QName(this.definition.getTargetNamespace(), this.getScope().toString() + "." + name);
        } else {
            result.setName(name);
        }
        duplicateTypeTrackerMap.put(qName.toString(), name);
        return result;
    }

    private Message generateMessage(XmlSchemaElement element, String name) {
        Part part = this.definition.createPart();
        part.setName(PART_NAME);
        part.setElementName(element.getQName());
        Message result = this.definition.createMessage();
        QName qName = new QName(this.definition.getTargetNamespace(), name);
        if (this.definition.getMessage(qName) != null) {
            String newName = this.getScope().toString() + "." + name;
            qName = new QName(this.definition.getTargetNamespace(), newName);
        }
        result.setQName(qName);
        result.addPart(part);
        result.setUndefined(false);
        this.definition.addMessage(result);
        return result;
    }

    private Operation generateOperation(String name, Message inputMsg, Message outputMsg) {
        Input input = this.definition.createInput();
        input.setName(inputMsg.getQName().getLocalPart());
        input.setMessage(inputMsg);
        Output output = this.definition.createOutput();
        output.setName(outputMsg.getQName().getLocalPart());
        output.setMessage(outputMsg);
        Operation result = this.definition.createOperation();
        result.setName(name);
        result.setInput(input);
        result.setOutput(output);
        result.setUndefined(false);
        this.portType.addOperation(result);
        return result;
    }

    private ArgType generateCorbaReturnParam(AST type) {
        ArgType param = new ArgType();
        param.setName(RETURN_PARAM_NAME);
        ParamTypeSpecVisitor visitor = new ParamTypeSpecVisitor(this.getScope(), this.definition, this.schema, this.wsdlVisitor);
        visitor.visit(type);
        CorbaType corbaType = visitor.getCorbaType();
        if (corbaType != null) {
            param.setIdltype(corbaType.getQName());
        } else {
            this.wsdlVisitor.getDeferredActions().add(visitor.getFullyQualifiedName(), new AttributeDeferredAction(param));
        }
        return param;
    }

    private ParamType generateCorbaParam(AST type) {
        ParamType param = new ParamType();
        param.setName(PARAM_NAME);
        param.setMode(ModeType.IN);
        ParamTypeSpecVisitor visitor = new ParamTypeSpecVisitor(this.getScope(), this.definition, this.schema, this.wsdlVisitor);
        visitor.visit(type);
        CorbaType corbaType = visitor.getCorbaType();
        if (corbaType != null) {
            param.setIdltype(corbaType.getQName());
        } else {
            this.wsdlVisitor.getDeferredActions().add(visitor.getFullyQualifiedName(), new AttributeDeferredAction(param));
        }
        return param;
    }

    private OperationType generateCorbaOperation(Operation op, ParamType param, ArgType arg) {
        OperationType operation = null;
        try {
            operation = (OperationType)this.extReg.createExtension(BindingOperation.class, CorbaConstants.NE_CORBA_OPERATION);
        }
        catch (WSDLException ex) {
            throw new RuntimeException(ex);
        }
        operation.setName(op.getName());
        if (param != null) {
            operation.getParam().add(param);
        }
        if (arg != null) {
            operation.setReturn(arg);
        }
        return operation;
    }

    private BindingOperation generateCorbaBindingOperation(Binding wsdlBinding, Operation op, OperationType corbaOp) {
        BindingInput bindingInput = this.definition.createBindingInput();
        bindingInput.setName(op.getInput().getName());
        BindingOutput bindingOutput = this.definition.createBindingOutput();
        bindingOutput.setName(op.getOutput().getName());
        BindingOperation bindingOperation = this.definition.createBindingOperation();
        bindingOperation.addExtensibilityElement((ExtensibilityElement)corbaOp);
        bindingOperation.setOperation(op);
        bindingOperation.setName(op.getName());
        bindingOperation.setBindingInput(bindingInput);
        bindingOperation.setBindingOutput(bindingOutput);
        this.binding.addBindingOperation(bindingOperation);
        return bindingOperation;
    }
}

