/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.Anonsequence;
import org.apache.cxf.binding.corba.wsdl.CorbaType;
import org.apache.cxf.binding.corba.wsdl.Sequence;
import org.apache.cxf.tools.corba.common.ReferenceConstants;
import org.apache.cxf.tools.corba.processors.idl.Scope;
import org.apache.cxf.tools.corba.processors.idl.SequenceDeferredAction;
import org.apache.cxf.tools.corba.processors.idl.SimpleTypeSpecVisitor;
import org.apache.cxf.tools.corba.processors.idl.TypesUtils;
import org.apache.cxf.tools.corba.processors.idl.VisitorBase;
import org.apache.cxf.tools.corba.processors.idl.WSDLASTVisitor;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.constants.Constants;

public class SequenceVisitor
extends VisitorBase {
    private static final String ELEMENT_NAME = "item";
    private AST identifierNode;

    public SequenceVisitor(Scope scope, Definition defn, XmlSchema schemaRef, WSDLASTVisitor wsdlVisitor, AST identifierNodeRef) {
        super(scope, defn, schemaRef, wsdlVisitor);
        this.identifierNode = identifierNodeRef;
    }

    public static boolean accept(AST node) {
        return node.getType() == 60;
    }

    @Override
    public void visit(AST seq) {
        String constValue;
        AST simpleTypeSpecNode = seq.getFirstChild();
        AST boundNode = TypesUtils.getCorbaTypeNameNode(simpleTypeSpecNode);
        if (boundNode != null && (constValue = TypesUtils.getConstValueByName(boundNode, this.typeMap)) != null) {
            boundNode.setText(constValue);
        }
        SimpleTypeSpecVisitor visitor = new SimpleTypeSpecVisitor(new Scope(this.getScope(), this.identifierNode), this.definition, this.schema, this.wsdlVisitor, null);
        visitor.visit(simpleTypeSpecNode);
        XmlSchemaType stype = visitor.getSchemaType();
        CorbaType ctype = visitor.getCorbaType();
        Scope fullyQualifiedName = visitor.getFullyQualifiedName();
        long bound = -1L;
        if (boundNode != null) {
            bound = Long.parseLong(boundNode.toString());
        }
        Scope scopedName = null;
        scopedName = this.identifierNode == null ? TypesUtils.generateAnonymousScopedName(this.getScope(), this.schema) : new Scope(this.getScope(), this.identifierNode);
        XmlSchemaType schemaType = null;
        schemaType = stype != null ? (!stype.getQName().equals(Constants.XSD_UNSIGNEDBYTE) ? this.generateSchemaType(stype, scopedName, bound, fullyQualifiedName) : this.wsdlVisitor.getSequenceOctetType()) : this.generateSchemaType(null, scopedName, bound, fullyQualifiedName);
        Object corbaType = null;
        corbaType = this.identifierNode == null ? this.generateCorbaAnonsequence(ctype, schemaType, scopedName, bound, fullyQualifiedName) : this.generateCorbaSequence(ctype, schemaType, scopedName, bound, fullyQualifiedName);
        this.setSchemaType(schemaType);
        this.setCorbaType((CorbaType)corbaType);
        this.setFullyQualifiedName(fullyQualifiedName);
    }

    private XmlSchemaType generateSchemaType(XmlSchemaType stype, Scope scopedName, long bound, Scope fullyQualifiedName) {
        XmlSchemaComplexType ct = new XmlSchemaComplexType(this.schema, true);
        ct.setName(this.mapper.mapToQName(scopedName));
        XmlSchemaSequence sequence = new XmlSchemaSequence();
        XmlSchemaElement el = new XmlSchemaElement(this.schema, false);
        el.setName(ELEMENT_NAME);
        el.setMinOccurs(0L);
        if (bound != -1L) {
            el.setMaxOccurs(bound);
        } else {
            el.setMaxOccurs(Long.MAX_VALUE);
        }
        if (stype != null) {
            el.setSchemaTypeName(stype.getQName());
            if (stype.getQName().equals(ReferenceConstants.WSADDRESSING_TYPE)) {
                el.setNillable(true);
            }
        } else {
            SequenceDeferredAction elementAction = new SequenceDeferredAction(el);
            this.wsdlVisitor.getDeferredActions().add(fullyQualifiedName, elementAction);
        }
        sequence.getItems().add(el);
        ct.setParticle((XmlSchemaParticle)sequence);
        return ct;
    }

    private CorbaType generateCorbaSequence(CorbaType ctype, XmlSchemaType schemaType, Scope scopedName, long bound, Scope fullyQualifiedName) {
        Sequence corbaSeq = new Sequence();
        if (bound == -1L) {
            bound = 0L;
        }
        corbaSeq.setBound(bound);
        corbaSeq.setQName(new QName(this.typeMap.getTargetNamespace(), scopedName.toString()));
        corbaSeq.setType(schemaType.getQName());
        corbaSeq.setElemname(new QName("", ELEMENT_NAME));
        if (ctype != null) {
            corbaSeq.setElemtype(ctype.getQName());
        } else {
            SequenceDeferredAction seqAction = new SequenceDeferredAction(corbaSeq);
            this.wsdlVisitor.getDeferredActions().add(fullyQualifiedName, seqAction);
        }
        corbaSeq.setRepositoryID(scopedName.toIDLRepositoryID());
        return corbaSeq;
    }

    private Anonsequence generateCorbaAnonsequence(CorbaType ctype, XmlSchemaType schemaType, Scope scopedName, long bound, Scope fullyQualifiedName) {
        SequenceDeferredAction anonSeqAction;
        Anonsequence result = new Anonsequence();
        if (bound == -1L) {
            bound = 0L;
        }
        result.setBound(bound);
        result.setQName(new QName(this.typeMap.getTargetNamespace(), scopedName.toString()));
        result.setElemname(new QName("", ELEMENT_NAME));
        if (schemaType == null || ctype == null) {
            anonSeqAction = new SequenceDeferredAction(result);
            this.wsdlVisitor.getDeferredActions().add(fullyQualifiedName, anonSeqAction);
        } else {
            result.setType(schemaType.getQName());
            result.setElemtype(ctype.getQName());
        }
        if (schemaType == null) {
            anonSeqAction = new SequenceDeferredAction(this.schemas, this.schema);
            this.wsdlVisitor.getDeferredActions().add(fullyQualifiedName, anonSeqAction);
        }
        this.typeMap.getStructOrExceptionOrUnion().add(result);
        return result;
    }
}

