/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.generators;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.common.model.JavaPort;
import org.apache.cxf.tools.common.model.JavaServiceClass;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.NameUtil;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.generators.AbstractJAXWSGenerator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.WSDLToJavaProcessor;

public class ImplGenerator
extends AbstractJAXWSGenerator {
    private static final String IMPL_TEMPLATE = "org/apache/cxf/tools/wsdlto/frontend/jaxws/template/impl.vm";

    public ImplGenerator() {
        this.name = "impl.generator";
    }

    @Override
    public boolean passthrough() {
        return !this.env.optionSet("genImpl") && !this.env.optionSet("impl") && !this.env.optionSet("all");
    }

    @Override
    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        if (this.passthrough()) {
            return;
        }
        Map map = CastUtils.cast((Map)((Map)penv.get(WSDLToJavaProcessor.MODEL_MAP)));
        for (JavaModel javaModel : map.values()) {
            Map interfaces = javaModel.getInterfaces();
            Map services = javaModel.getServiceClasses();
            JavaServiceClass service = null;
            if (!services.values().isEmpty()) {
                Iterator<Object> iterator = services.values().iterator();
                while (iterator.hasNext()) {
                    JavaServiceClass javaServiceClass;
                    service = javaServiceClass = (JavaServiceClass)iterator.next();
                    for (JavaPort jport : javaServiceClass.getPorts()) {
                        JavaInterface intf = (JavaInterface)interfaces.get(jport.getInterfaceClass());
                        this.outputImpl(intf, service, jport.getPortName(), penv);
                    }
                }
                continue;
            }
            for (Map.Entry entry : interfaces.entrySet()) {
                this.outputImpl((JavaInterface)entry.getValue(), null, "", penv);
            }
        }
    }

    private void outputImpl(JavaInterface intf, JavaServiceClass service, String port, ToolContext penv) {
        this.clearAttributes();
        this.setAttributes("intf", intf);
        this.setAttributes("service", service);
        this.setAttributes("port", port);
        this.setCommonAttributes();
        if (StringUtils.isEmpty((String)port)) {
            port = intf.getName();
        }
        String name = this.getImplName(port, service == null ? "" : service.getName(), intf, penv);
        this.setAttributes("implName", name);
        this.doWrite(IMPL_TEMPLATE, this.parseOutputName(intf.getPackageName(), name));
    }

    private String getImplName(String port, String service, JavaInterface intf, ToolContext penv) {
        String name;
        HashMap<String, String> nm = CastUtils.cast((Map)((Map)penv.get("implClass")));
        if (nm == null) {
            nm = new HashMap<String, String>();
            penv.put("implClass", nm);
        }
        if ((name = (String)nm.get(service + "/" + port)) == null) {
            name = NameUtil.mangleNameToClassName((String)(port + "Impl"), (boolean)true);
            name = this.mapClassName(intf.getPackageName(), name, penv);
            nm.put(service + "/" + port, name);
        }
        return name;
    }

    private String mapClassName(String packageName, String name, ToolContext context) {
        ClassCollector collector = (ClassCollector)context.get(ClassCollector.class);
        int count = 0;
        String checkName = name;
        while (collector.containImplClass(packageName, checkName)) {
            checkName = name + ++count;
        }
        collector.addImplClassName(packageName, checkName, packageName + "." + checkName);
        return checkName;
    }
}

