/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.CorbaBindingException;
import org.apache.cxf.binding.corba.CorbaServerConduit;
import org.apache.cxf.binding.corba.CorbaTypeMap;
import org.apache.cxf.binding.corba.TypeMapCache;
import org.apache.cxf.binding.corba.runtime.CorbaDSIServant;
import org.apache.cxf.binding.corba.utils.CorbaBindingHelper;
import org.apache.cxf.binding.corba.utils.CorbaUtils;
import org.apache.cxf.binding.corba.utils.OrbConfig;
import org.apache.cxf.binding.corba.wsdl.AddressType;
import org.apache.cxf.binding.corba.wsdl.PolicyType;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.MultiplexDestination;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.EndpointReferenceUtils;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.Current;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ThreadPolicyValue;

public class CorbaDestination
implements MultiplexDestination {
    private static final String IOR_SHARED_KEY = "ior:shared-key";
    private static final Logger LOG = LogUtils.getL7dLogger(CorbaDestination.class);
    private AddressType address;
    private EndpointReferenceType reference;
    private ORB orb;
    private BindingInfo binding;
    private EndpointInfo endpointInfo;
    private OrbConfig orbConfig;
    private MessageObserver incomingObserver;
    private CorbaTypeMap typeMap;
    private byte[] objectId;
    private POA bindingPOA;
    private String poaName;
    private String serviceId;
    private boolean isPersistent;
    private Object obj;

    public CorbaDestination(EndpointInfo ei, OrbConfig config) {
        this(ei, config, null);
    }

    public CorbaDestination(EndpointInfo ei, OrbConfig config, CorbaTypeMap tm) {
        this.address = (AddressType)ei.getExtensor(AddressType.class);
        this.binding = ei.getBinding();
        this.reference = new EndpointReferenceType();
        AttributedURIType addr = new AttributedURIType();
        addr.setValue(this.address.getLocation());
        this.reference.setAddress(addr);
        this.endpointInfo = ei;
        this.orbConfig = config;
        this.typeMap = tm != null ? tm : TypeMapCache.get(this.binding.getService());
        PolicyType policy = (PolicyType)ei.getExtensor(PolicyType.class);
        if (policy != null) {
            this.poaName = policy.getPoaname();
            this.isPersistent = policy.isPersistent();
            this.serviceId = policy.getServiceid();
        }
    }

    public OrbConfig getOrbConfig() {
        return this.orbConfig;
    }

    public EndpointReferenceType getAddress() {
        return this.reference;
    }

    public Conduit getBackChannel(Message inMessage) throws IOException {
        return new CorbaServerConduit(this.endpointInfo, this.reference, this.obj, this.orb, this.orbConfig, this.typeMap);
    }

    public BindingInfo getBindingInfo() {
        return this.binding;
    }

    public EndpointInfo getEndPointInfo() {
        return this.endpointInfo;
    }

    public CorbaTypeMap getCorbaTypeMap() {
        return this.typeMap;
    }

    public void shutdown() {
        this.deactivate();
        if (this.orb != null) {
            try {
                if (CorbaUtils.isIOR(this.getDestinationAddress())) {
                    CorbaBindingHelper.destroyORB(IOR_SHARED_KEY, this.orb);
                } else {
                    CorbaBindingHelper.destroyORB(this.getDestinationAddress(), this.orb);
                }
            }
            catch (Exception ex) {
                throw new CorbaBindingException(ex);
            }
            this.orb = null;
        }
    }

    public ORB getORB(List<String> orbArgs, String location, Properties props) {
        if (CorbaUtils.isIOR(location)) {
            location = IOR_SHARED_KEY;
        }
        this.orb = CorbaBindingHelper.getAddressSpecificORB(location, props, orbArgs);
        CorbaBindingHelper.keepORBAlive(location);
        return this.orb;
    }

    protected ORB getOrb() {
        return this.orb;
    }

    protected AddressType getAddressType() {
        return this.address;
    }

    public synchronized void setMessageObserver(MessageObserver observer) {
        if (observer != this.incomingObserver) {
            MessageObserver old = this.incomingObserver;
            this.incomingObserver = observer;
            if (observer != null) {
                if (old == null) {
                    this.activate();
                }
            } else if (old != null) {
                this.deactivate();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void activate() {
        props = new Properties();
        configSpecifiedOrbProperties = this.orbConfig.getOrbProperties();
        props.putAll((Map<?, ?>)configSpecifiedOrbProperties);
        if (this.orbConfig.getOrbClass() != null) {
            props.put("org.omg.CORBA.ORBClass", this.orbConfig.getOrbClass());
        }
        if (this.orbConfig.getOrbSingletonClass() != null) {
            props.put("org.omg.CORBA.ORBSingletonClass", this.orbConfig.getOrbSingletonClass());
        }
        if (!CorbaUtils.isValidURL(location = this.getDestinationAddress())) {
            throw new CorbaBindingException("Invalid addressing specified for CORBA port location");
        }
        CorbaDestination.LOG.info("Service address retrieved: " + location);
        try {
            addressURI = new URI(location);
        }
        catch (URISyntaxException ex) {
            throw new CorbaBindingException("Unable to create ORB with address " + this.address);
        }
        orbArgs = new ArrayList<String>(this.orbConfig.getOrbArgs());
        scheme = addressURI.getScheme();
        if (this.poaName != null) {
            this.poaName = this.poaName.replace('.', '_');
        }
        if ("corbaloc".equals(scheme)) {
            if (this.poaName == null) {
                this.poaName = this.getEndPointInfo().getName().getLocalPart().replace('.', '_');
            }
            this.setCorbaLocArgs(addressURI, orbArgs);
        } else if ("corbaname".equals(scheme) && (idx = location.indexOf(35)) != -1) {
            this.serviceId = location.substring(idx + 1);
        }
        if (this.isPersistent) {
            if (this.poaName == null) {
                throw new CorbaBindingException("POA name missing for corba port with a persistent policy");
            }
        } else {
            this.poaName = CorbaUtils.getUniquePOAName(this.getEndPointInfo().getService().getName(), this.getEndPointInfo().getName().getLocalPart(), this.poaName).replace('.', '_');
        }
        this.orb = this.getORB(orbArgs, location, props);
        try {
            rootPOA = POAHelper.narrow((Object)this.orb.resolve_initial_references("RootPOA"));
            poaManager = rootPOA.the_POAManager();
            try {
                this.bindingPOA = rootPOA.find_POA(this.poaName, false);
            }
            catch (AdapterNonExistent var9_12) {
                // empty catch block
            }
            if (this.bindingPOA != null && !this.isPersistent && this.serviceId == null) {
                throw new CorbaBindingException("Corba Port activation failed because the poa " + this.poaName + " already exists");
            }
            if (this.bindingPOA == null) {
                this.bindingPOA = this.createPOA(this.poaName, rootPOA, poaManager);
            }
            if (this.bindingPOA == null) {
                throw new CorbaBindingException("Unable to create CXF CORBA Binding POA");
            }
            servant = new CorbaDSIServant();
            servant.init(this.orb, this.bindingPOA, this, this.incomingObserver, this.typeMap);
            if (this.serviceId != null) {
                this.objectId = this.serviceId.getBytes();
                try {
                    this.bindingPOA.activate_object_with_id(this.objectId, (Servant)servant);
                }
                catch (ObjectAlreadyActive ex) {
                    if (this.isPersistent) ** GOTO lbl60
                    throw new CorbaBindingException("Object " + this.serviceId + " already active for non-persistent poa");
                }
            } else {
                this.objectId = this.bindingPOA.activate_object((Servant)servant);
            }
lbl60:
            // 3 sources

            this.bindingPOA.set_servant((Servant)servant);
            this.obj = this.bindingPOA.id_to_reference(this.objectId);
            this.orbConfig.exportObjectReference(this.orb, this.obj, location, this.address);
            this.populateEpr(this.orb.object_to_string(this.obj));
            CorbaDestination.LOG.info("Object Reference: " + this.orb.object_to_string(this.obj));
            poaManager.activate();
        }
        catch (Exception ex) {
            throw new CorbaBindingException("Unable to activate CORBA servant", ex);
        }
    }

    private void populateEpr(String ior) {
        AttributedURIType addr = new AttributedURIType();
        addr.setValue(ior);
        this.reference.setAddress(addr);
    }

    public String getDestinationAddress() {
        String location = null;
        if (this.endpointInfo != null) {
            location = this.endpointInfo.getAddress();
        }
        if (location == null) {
            location = this.address.getLocation();
        }
        return location;
    }

    public MessageObserver getMessageObserver() {
        return this.incomingObserver;
    }

    public void deactivate() {
        if (this.orb != null) {
            if (this.bindingPOA == null) {
                throw new CorbaBindingException("Corba Port deactivation failed because the poa is null");
            }
            try {
                this.bindingPOA.deactivate_object(this.objectId);
            }
            catch (ObjectNotActive ona) {
                LOG.info("Caught ObjectNotActive exception: " + (java.lang.Object)((java.lang.Object)ona) + " during deactivate_object() call on POA: " + this.bindingPOA);
            }
            catch (Exception ex) {
                throw new CorbaBindingException("Unable to deactivate CORBA servant", ex);
            }
        }
    }

    private void setCorbaLocArgs(URI addressURI, List<String> orbArgs) {
        String schemeSpecificPart = addressURI.getSchemeSpecificPart();
        int keyIndex = schemeSpecificPart.indexOf(47);
        String corbaAddr = schemeSpecificPart.substring(0, keyIndex);
        String key = schemeSpecificPart.substring(keyIndex + 1);
        int index = corbaAddr.indexOf(58);
        String protocol = "iiop";
        if (index != 0) {
            protocol = corbaAddr.substring(0, index);
        }
        int oldIndex = index;
        index = corbaAddr.indexOf(58, oldIndex + 1);
        String host = corbaAddr.substring(oldIndex + 1, index);
        String port = corbaAddr.substring(index + 1);
        orbArgs.add("-ORB" + key + ":" + protocol + ":host");
        orbArgs.add(host);
        orbArgs.add("-ORB" + key + ":" + protocol + ":port");
        orbArgs.add(port);
        orbArgs.add("-ORBpoa:" + this.poaName + ":direct_persistent");
        orbArgs.add("true");
        orbArgs.add("-ORBpoa:" + this.poaName + ":well_known_address");
        orbArgs.add(key);
        this.isPersistent = true;
        this.serviceId = key;
    }

    protected POA createPOA(String name, POA parentPOA, POAManager poaManager) {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        policies.add((Policy)parentPOA.create_thread_policy(ThreadPolicyValue.ORB_CTRL_MODEL));
        if (this.isPersistent) {
            policies.add((Policy)parentPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT));
        } else {
            policies.add((Policy)parentPOA.create_lifespan_policy(LifespanPolicyValue.TRANSIENT));
        }
        if (this.serviceId != null) {
            policies.add((Policy)parentPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID));
        }
        policies.add((Policy)parentPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID));
        RequestProcessingPolicyValue value = RequestProcessingPolicyValue.USE_DEFAULT_SERVANT;
        policies.add((Policy)parentPOA.create_request_processing_policy(value));
        this.orbConfig.addPOAPolicies(this.orb, name, parentPOA, poaManager, policies);
        Policy[] policyList = policies.toArray(new Policy[0]);
        try {
            return parentPOA.create_POA(name, poaManager, policyList);
        }
        catch (Exception ex) {
            throw new CorbaBindingException("Could not create POA during activation", ex);
        }
    }

    public EndpointReferenceType getAddressWithId(String id) {
        EndpointReferenceType ref;
        if (this.bindingPOA == null) {
            throw new CorbaBindingException("getAddressWithId failed because the poa is null");
        }
        try {
            Servant servant = this.bindingPOA.id_to_servant(this.objectId);
            Object objRef = this.bindingPOA.create_reference_with_id(id.getBytes(), servant._all_interfaces(this.bindingPOA, this.objectId)[0]);
            AddressType addr = new AddressType();
            this.orbConfig.exportObjectReference(this.orb, objRef, this.address.getLocation(), addr);
            ref = EndpointReferenceUtils.getEndpointReference((String)addr.getLocation());
            EndpointInfo ei = this.getEndPointInfo();
            if (ei.getService() != null) {
                EndpointReferenceUtils.setServiceAndPortName((EndpointReferenceType)ref, (QName)ei.getService().getName(), (String)ei.getName().getLocalPart());
            }
        }
        catch (Exception e) {
            throw new CorbaBindingException("Failed to getAddressWithId, reason:" + e.toString(), e);
        }
        return ref;
    }

    public String getId(Map<String, java.lang.Object> contextMap) {
        try {
            Current currentPoa = (Current)this.orb.resolve_initial_references("POACurrent");
            byte[] idBytes = currentPoa.get_object_id();
            return new String(idBytes);
        }
        catch (Exception e) {
            throw new CorbaBindingException("Unable to getId, current is unavailable, reason: " + e, e);
        }
    }
}

