/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.offheapstore.storage;

import org.ehcache.shadow.org.terracotta.offheapstore.storage.HalfStorageEngine;
import org.ehcache.shadow.org.terracotta.offheapstore.storage.SplitStorageEngine;
import org.ehcache.shadow.org.terracotta.offheapstore.storage.StorageEngine;
import org.ehcache.shadow.org.terracotta.offheapstore.util.Factory;

public class LongStorageEngine<V>
implements StorageEngine<Long, V> {
    private final HalfStorageEngine<V> valueStorage;

    public static <V> Factory<LongStorageEngine<V>> createFactory(Factory<? extends HalfStorageEngine<V>> valueFactory) {
        return () -> new LongStorageEngine((HalfStorageEngine)valueFactory.newInstance());
    }

    public LongStorageEngine(HalfStorageEngine<V> valueStorage) {
        this.valueStorage = valueStorage;
    }

    @Override
    public Long writeMapping(Long key, V value, int hash, int metadata) {
        Integer valueEncoding = this.valueStorage.write(value, hash);
        if (valueEncoding == null) {
            return null;
        }
        return SplitStorageEngine.encoding(key.intValue(), valueEncoding);
    }

    @Override
    public void attachedMapping(long encoding, int hash, int metadata) {
    }

    @Override
    public void freeMapping(long encoding, int hash, boolean removal) {
        this.valueStorage.free(SplitStorageEngine.valueEncoding(encoding));
    }

    @Override
    public V readValue(long encoding) {
        return this.valueStorage.read(SplitStorageEngine.valueEncoding(encoding));
    }

    @Override
    public boolean equalsValue(Object value, long encoding) {
        return this.valueStorage.equals(value, SplitStorageEngine.valueEncoding(encoding));
    }

    @Override
    public Long readKey(long encoding, int hashCode) {
        int keyEncoding = SplitStorageEngine.keyEncoding(encoding);
        return (long)(hashCode ^ keyEncoding) << 32 | (long)keyEncoding & 0xFFFFFFFFL;
    }

    @Override
    public boolean equalsKey(Object key, long encoding) {
        return key instanceof Long && ((Long)key).intValue() == SplitStorageEngine.keyEncoding(encoding);
    }

    @Override
    public void clear() {
    }

    @Override
    public long getAllocatedMemory() {
        return this.valueStorage.getAllocatedMemory();
    }

    @Override
    public long getOccupiedMemory() {
        return this.valueStorage.getOccupiedMemory();
    }

    @Override
    public long getVitalMemory() {
        return this.valueStorage.getVitalMemory();
    }

    @Override
    public long getDataSize() {
        return this.valueStorage.getDataSize();
    }

    public String toString() {
        return "LongStorageEngine : " + this.valueStorage;
    }

    @Override
    public void invalidateCache() {
        this.valueStorage.invalidateCache();
    }

    @Override
    public void bind(StorageEngine.Owner owner) {
        this.valueStorage.bind(owner, 0xFFFFFFFFL);
    }

    @Override
    public void destroy() {
        this.valueStorage.destroy();
    }

    @Override
    public boolean shrink() {
        return this.valueStorage.shrink();
    }
}

