/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.client.reactive.ReactorNetty2ClientHttpRequest;
import org.springframework.http.client.reactive.ReactorNetty2ClientHttpResponse;
import org.springframework.http.client.reactive.ReactorNetty2ResourceFactory;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.netty5.Connection;
import reactor.netty5.NettyOutbound;
import reactor.netty5.http.client.HttpClient;
import reactor.netty5.http.client.HttpClientRequest;
import reactor.netty5.http.client.HttpClientResponse;
import reactor.netty5.resources.ConnectionProvider;
import reactor.netty5.resources.LoopResources;

public class ReactorNetty2ClientHttpConnector
implements ClientHttpConnector {
    private static final Function<HttpClient, HttpClient> defaultInitializer = client -> client.compress(true);
    private final HttpClient httpClient;

    public ReactorNetty2ClientHttpConnector() {
        this.httpClient = defaultInitializer.apply(HttpClient.create().wiretap(true));
    }

    public ReactorNetty2ClientHttpConnector(ReactorNetty2ResourceFactory factory, Function<HttpClient, HttpClient> mapper) {
        ConnectionProvider provider = factory.getConnectionProvider();
        Assert.notNull((Object)provider, (String)"No ConnectionProvider: is ReactorNetty2ResourceFactory not initialized yet?");
        this.httpClient = defaultInitializer.andThen(mapper).andThen(ReactorNetty2ClientHttpConnector.applyLoopResources(factory)).apply(HttpClient.create((ConnectionProvider)provider));
    }

    private static Function<HttpClient, HttpClient> applyLoopResources(ReactorNetty2ResourceFactory factory) {
        return httpClient -> {
            LoopResources resources = factory.getLoopResources();
            Assert.notNull((Object)resources, (String)"No LoopResources: is ReactorNetty2ResourceFactory not initialized yet?");
            return (HttpClient)httpClient.runOn(resources);
        };
    }

    public ReactorNetty2ClientHttpConnector(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, (String)"HttpClient is required");
        this.httpClient = httpClient;
    }

    @Override
    public Mono<ClientHttpResponse> connect(HttpMethod method, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        AtomicReference responseRef = new AtomicReference();
        HttpClient.RequestSender requestSender = this.httpClient.request(io.netty5.handler.codec.http.HttpMethod.valueOf((String)method.name()));
        requestSender = uri.isAbsolute() ? (HttpClient.RequestSender)requestSender.uri(uri) : (HttpClient.RequestSender)requestSender.uri(uri.toString());
        return requestSender.send((request, outbound) -> (Publisher)requestCallback.apply(this.adaptRequest(method, uri, (HttpClientRequest)request, (NettyOutbound)outbound))).responseConnection((response, connection) -> {
            responseRef.set(new ReactorNetty2ClientHttpResponse((HttpClientResponse)response, (Connection)connection));
            return Mono.just((Object)((ClientHttpResponse)responseRef.get()));
        }).next().doOnCancel(() -> {
            ReactorNetty2ClientHttpResponse response = (ReactorNetty2ClientHttpResponse)responseRef.get();
            if (response != null) {
                response.releaseAfterCancel(method);
            }
        });
    }

    private ReactorNetty2ClientHttpRequest adaptRequest(HttpMethod method, URI uri, HttpClientRequest request, NettyOutbound nettyOutbound) {
        return new ReactorNetty2ClientHttpRequest(method, uri, request, nettyOutbound);
    }
}

