/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view.predicate;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.apache.activemq.artemis.core.management.impl.view.ConnectionField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ActiveMQFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;

public class ConnectionFilterPredicate
extends ActiveMQFilterPredicate<RemotingConnection> {
    private ConnectionField f;
    private ActiveMQServer server;

    public ConnectionFilterPredicate(ActiveMQServer server) {
        this.server = server;
    }

    @Override
    public boolean test(RemotingConnection connection) {
        if (this.f == null) {
            return true;
        }
        switch (this.f) {
            case CONNECTION_ID: {
                return this.matches(connection.getID());
            }
            case CLIENT_ID: {
                return this.matches(connection.getClientID());
            }
            case USERS: {
                return this.matchAny(this.collectFromSessions(connection.getID().toString(), s -> s.getUsername()));
            }
            case PROTOCOL: {
                return this.matches(connection.getProtocolName());
            }
            case SESSION_COUNT: {
                return this.matches(this.server.getSessions(connection.getID().toString()).size());
            }
            case REMOTE_ADDRESS: {
                return this.matches(connection.getTransportConnection().getRemoteAddress());
            }
            case LOCAL_ADDRESS: {
                return this.matches(connection.getTransportConnection().getLocalAddress());
            }
            case SESSION_ID: {
                return this.matchAny(this.server.getSessions(connection.getID().toString()));
            }
            case CREATION_TIME: {
                return this.matches(connection.getCreationTime());
            }
            case IMPLEMENTATION: {
                return this.matches(connection.getClass().getSimpleName());
            }
        }
        return true;
    }

    Set<String> collectFromSessions(String connectionId, Function<ServerSession, String> getter) {
        List<ServerSession> sessions = this.server.getSessions(connectionId);
        HashSet<String> sessionAttributes = new HashSet<String>();
        for (ServerSession session : sessions) {
            String value = getter.apply(session);
            String string = value == null ? "" : value;
            sessionAttributes.add(string);
        }
        return sessionAttributes;
    }

    @Override
    public void setField(String field) {
        if (field != null && !field.equals("")) {
            this.f = ConnectionField.valueOfName(field);
            if (this.f == null) {
                this.f = ConnectionField.valueOf(field);
            }
        }
    }
}

