/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.json;

import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.impl.JsonArrayImpl;
import org.apache.activemq.artemis.json.impl.JsonObjectImpl;
import org.apache.activemq.artemis.json.impl.JsonValueImpl;

public interface JsonValue {
    public static final JsonObject EMPTY_JSON_OBJECT = new JsonObjectImpl(org.apache.activemq.artemis.commons.shaded.json.JsonValue.EMPTY_JSON_OBJECT);
    public static final JsonArray EMPTY_JSON_ARRAY = new JsonArrayImpl(org.apache.activemq.artemis.commons.shaded.json.JsonValue.EMPTY_JSON_ARRAY);
    public static final JsonValue NULL = new JsonValueImpl(org.apache.activemq.artemis.commons.shaded.json.JsonValue.NULL);
    public static final JsonValue TRUE = new JsonValueImpl(org.apache.activemq.artemis.commons.shaded.json.JsonValue.TRUE);
    public static final JsonValue FALSE = new JsonValueImpl(org.apache.activemq.artemis.commons.shaded.json.JsonValue.FALSE);

    public ValueType getValueType();

    public String toString();

    default public JsonObject asJsonObject() {
        return (JsonObject)JsonObject.class.cast(this);
    }

    default public JsonArray asJsonArray() {
        return (JsonArray)JsonArray.class.cast(this);
    }

    public static enum ValueType {
        ARRAY,
        OBJECT,
        STRING,
        NUMBER,
        TRUE,
        FALSE,
        NULL;

    }
}

