/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.xml2fastinfoset;

import com.sun.xml.fastinfoset.sax.SAXDocumentSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Scanner;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XML2FastInfosetCompilerMojo
extends AbstractMojo {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.xml"};
    private MavenProject project;
    private List resources;
    private Set includes = new HashSet();
    private Set excludes = new HashSet();
    private File outputDirectory;
    protected BuildContext buildContext;

    public void execute() throws MojoExecutionException {
        for (Resource resource : this.resources) {
            String targetPath = resource.getTargetPath();
            File resourceDirectory = new File(resource.getDirectory());
            if (!resourceDirectory.isAbsolute()) {
                resourceDirectory = new File(this.project.getBasedir(), resourceDirectory.getPath());
            }
            if (!resourceDirectory.exists()) {
                this.getLog().debug((CharSequence)("Resource directory does not exist: " + resourceDirectory));
                continue;
            }
            Scanner scanner = this.buildContext.newScanner(resourceDirectory);
            if (this.includes != null && !this.includes.isEmpty()) {
                scanner.setIncludes(this.includes.toArray(EMPTY_STRING_ARRAY));
            } else {
                scanner.setIncludes(DEFAULT_INCLUDES);
            }
            if (this.excludes != null && !this.excludes.isEmpty()) {
                scanner.setExcludes(this.excludes.toArray(EMPTY_STRING_ARRAY));
            }
            scanner.addDefaultExcludes();
            scanner.scan();
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            this.getLog().debug((CharSequence)("FastInfosetting " + includedFiles.size() + " resource" + (includedFiles.size() > 1 ? "s" : "") + (targetPath == null ? "" : " to " + targetPath)));
            if (includedFiles.size() > 0 && !this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
                throw new MojoExecutionException("Cannot create resource output directory: " + this.outputDirectory);
            }
            for (String name : includedFiles) {
                String destination = name.replaceFirst("\\.xml$", ".fixml");
                if (targetPath != null) {
                    destination = targetPath + "/" + name;
                }
                File source = new File(resourceDirectory, name);
                File destinationFile = new File(this.outputDirectory, destination);
                if (!destinationFile.getParentFile().exists()) {
                    destinationFile.getParentFile().mkdirs();
                }
                try {
                    this.compileFile(source, destinationFile);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Error copying resource " + source, e);
                }
                this.buildContext.refresh(destinationFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileFile(File sourceFile, File destinationFile) throws ParserConfigurationException, SAXException, IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(sourceFile);
            fos = new FileOutputStream(destinationFile);
            this.dehydrate(fis, fos);
            fis.close();
            fos.close();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void dehydrate(InputStream input, OutputStream output) throws ParserConfigurationException, SAXException, IOException {
        SAXDocumentSerializer saxDocumentSerializer = new SAXDocumentSerializer();
        saxDocumentSerializer.setOutputStream(output);
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        saxParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        saxParserFactory.setNamespaceAware(true);
        SAXParser saxParser = saxParserFactory.newSAXParser();
        saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", saxDocumentSerializer);
        saxParser.parse(input, (DefaultHandler)saxDocumentSerializer);
    }
}

