/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.xmlschema;

import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.cxf.common.xmlschema.InvalidXmlSchemaReferenceException;
import org.apache.cxf.common.xmlschema.XmlSchemaUtils;
import org.apache.ws.commons.schema.ValidationEventHandler;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaObjectTable;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.extensions.ExtensionRegistry;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.apache.ws.commons.schema.utils.TargetNamespaceValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SchemaCollection {
    private static final Method GET_ELEMENT_BY_NAME_METHOD;
    private XmlSchemaCollection schemaCollection;
    private Map<XmlSchema, Set<XmlSchemaType>> xmlTypesCheckedForCrossImportsPerSchema = new HashMap<XmlSchema, Set<XmlSchemaType>>();

    public SchemaCollection() {
        this(new XmlSchemaCollection());
    }

    public SchemaCollection(XmlSchemaCollection col) {
        this.schemaCollection = col;
        if (this.schemaCollection.getNamespaceContext() == null) {
            this.schemaCollection.setNamespaceContext((NamespacePrefixList)new NamespaceMap());
        }
    }

    public XmlSchemaCollection getXmlSchemaCollection() {
        return this.schemaCollection;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SchemaCollection) {
            return this.schemaCollection.equals(((SchemaCollection)obj).schemaCollection);
        }
        if (obj instanceof XmlSchemaCollection) {
            return this.schemaCollection.equals(obj);
        }
        return false;
    }

    public XmlSchemaElement getElementByQName(QName qname) {
        return this.schemaCollection.getElementByQName(qname);
    }

    public XmlSchemaAttribute getAttributeByQName(QName qname) {
        String uri = qname.getNamespaceURI();
        for (XmlSchema schema : this.schemaCollection.getXmlSchemas()) {
            XmlSchemaObjectTable attributes;
            XmlSchemaAttribute attribute;
            if (!uri.equals(schema.getTargetNamespace()) || (attribute = (XmlSchemaAttribute)(attributes = schema.getAttributes()).getItem(qname)) == null) continue;
            return attribute;
        }
        return null;
    }

    public ExtensionRegistry getExtReg() {
        return this.schemaCollection.getExtReg();
    }

    public NamespacePrefixList getNamespaceContext() {
        return this.schemaCollection.getNamespaceContext();
    }

    public XmlSchemaType getTypeByQName(QName schemaTypeName) {
        XmlSchemaType xst = this.schemaCollection.getTypeByQName(schemaTypeName);
        if (xst == null && "http://www.w3.org/2001/XMLSchema".equals(schemaTypeName.getNamespaceURI())) {
            XmlSchema sch = this.getSchemaByTargetNamespace(schemaTypeName.getNamespaceURI());
            if ("anySimpleType".equals(schemaTypeName.getLocalPart())) {
                XmlSchemaSimpleType type = new XmlSchemaSimpleType(sch);
                type.setName(schemaTypeName.getLocalPart());
                sch.addType((XmlSchemaType)type);
                xst = type;
            } else if ("anyType".equals(schemaTypeName.getLocalPart())) {
                XmlSchemaType type = new XmlSchemaType(sch);
                type.setName(schemaTypeName.getLocalPart());
                sch.addType(type);
                xst = type;
            }
        }
        return xst;
    }

    public XmlSchema[] getXmlSchema(String systemId) {
        return this.schemaCollection.getXmlSchema(systemId);
    }

    public XmlSchema[] getXmlSchemas() {
        return this.schemaCollection.getXmlSchemas();
    }

    public int hashCode() {
        return this.schemaCollection.hashCode();
    }

    public void init() {
        this.schemaCollection.init();
    }

    public XmlSchema read(Document doc, String uri, ValidationEventHandler veh, TargetNamespaceValidator validator) {
        return this.schemaCollection.read(doc, uri, veh, validator);
    }

    public XmlSchema read(Document doc, String uri, ValidationEventHandler veh) {
        return this.schemaCollection.read(doc, uri, veh);
    }

    public XmlSchema read(Document doc, ValidationEventHandler veh) {
        return this.schemaCollection.read(doc, veh);
    }

    public XmlSchema read(Element elem, String uri) {
        return this.schemaCollection.read(elem, uri);
    }

    public XmlSchema read(Element elem) {
        return this.schemaCollection.read(elem);
    }

    public XmlSchema read(InputSource inputSource, ValidationEventHandler veh) {
        return this.schemaCollection.read(inputSource, veh);
    }

    public XmlSchema read(Reader r, ValidationEventHandler veh) {
        return this.schemaCollection.read(r, veh);
    }

    public XmlSchema read(Source source, ValidationEventHandler veh) {
        return this.schemaCollection.read(source, veh);
    }

    public void setBaseUri(String baseUri) {
        this.schemaCollection.setBaseUri(baseUri);
    }

    public void setExtReg(ExtensionRegistry extReg) {
        this.schemaCollection.setExtReg(extReg);
    }

    public void setNamespaceContext(NamespacePrefixList namespaceContext) {
        this.schemaCollection.setNamespaceContext(namespaceContext);
    }

    public void setSchemaResolver(URIResolver schemaResolver) {
        this.schemaCollection.setSchemaResolver(schemaResolver);
    }

    public XmlSchema getSchemaByTargetNamespace(String namespaceURI) {
        for (XmlSchema schema : this.schemaCollection.getXmlSchemas()) {
            if (!namespaceURI.equals(schema.getTargetNamespace())) continue;
            return schema;
        }
        return null;
    }

    public XmlSchema getSchemaForElement(QName name) {
        for (XmlSchema schema : this.schemaCollection.getXmlSchemas()) {
            if (!name.getNamespaceURI().equals(schema.getTargetNamespace())) continue;
            try {
                if (!(GET_ELEMENT_BY_NAME_METHOD != null ? GET_ELEMENT_BY_NAME_METHOD.invoke((Object)schema, name.getLocalPart()) != null : schema.getElementByName(name) != null)) continue;
                return schema;
            }
            catch (InvocationTargetException ex) {
            }
            catch (IllegalAccessException ex) {
                // empty catch block
            }
        }
        return null;
    }

    public XmlSchema newXmlSchemaInCollection(String namespaceURI) {
        return new XmlSchema(namespaceURI, this.schemaCollection);
    }

    public void validateQNameNamespace(QName qname) {
        if ("".equals(qname.getNamespaceURI())) {
            return;
        }
        for (XmlSchema schema : this.schemaCollection.getXmlSchemas()) {
            if (!schema.getTargetNamespace().equals(qname.getNamespaceURI())) continue;
            return;
        }
        throw new InvalidXmlSchemaReferenceException(qname + " refers to unknown namespace.");
    }

    public void validateElementName(QName referrer, QName elementQName) {
        XmlSchemaElement element = this.schemaCollection.getElementByQName(elementQName);
        if (element == null) {
            throw new InvalidXmlSchemaReferenceException(referrer + " references non-existent element " + elementQName);
        }
    }

    public void validateTypeName(QName referrer, QName typeQName) {
        XmlSchemaType type = this.schemaCollection.getTypeByQName(typeQName);
        if (type == null) {
            throw new InvalidXmlSchemaReferenceException(referrer + " references non-existent type " + typeQName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGlobalElementToSchema(XmlSchemaElement element) {
        SchemaCollection schemaCollection = this;
        synchronized (schemaCollection) {
            XmlSchema schema = this.getSchemaByTargetNamespace(element.getQName().getNamespaceURI());
            if (schema == null) {
                schema = this.newXmlSchemaInCollection(element.getQName().getNamespaceURI());
            }
            schema.getItems().add((XmlSchemaObject)element);
            schema.getElements().add(element.getQName(), (XmlSchemaObject)element);
        }
    }

    public void addCrossImports() {
        for (XmlSchema schema : this.schemaCollection.getXmlSchemas()) {
            this.addOneSchemaCrossImports(schema);
        }
    }

    private void addOneSchemaCrossImports(XmlSchema schema) {
        for (int x = 0; x < schema.getItems().getCount(); ++x) {
            XmlSchemaObject item = schema.getItems().getItem(x);
            if (item instanceof XmlSchemaElement) {
                this.addElementCrossImportsElement(schema, item);
                continue;
            }
            if (item instanceof XmlSchemaAttribute) {
                XmlSchemaAttribute attr = (XmlSchemaAttribute)item;
                XmlSchemaUtils.addImportIfNeeded(schema, attr.getRefName());
                XmlSchemaUtils.addImportIfNeeded(schema, attr.getSchemaTypeName());
                if (attr.getSchemaType() == null) continue;
                XmlSchemaUtils.addImportIfNeeded(schema, attr.getSchemaType().getBaseSchemaTypeName());
                continue;
            }
            if (!(item instanceof XmlSchemaType)) continue;
            XmlSchemaType type = (XmlSchemaType)item;
            this.addCrossImportsType(schema, type);
        }
    }

    private void addElementCrossImportsElement(XmlSchema schema, XmlSchemaObject item) {
        XmlSchemaElement element = (XmlSchemaElement)item;
        XmlSchemaUtils.addImportIfNeeded(schema, element.getRefName());
        XmlSchemaUtils.addImportIfNeeded(schema, element.getSchemaTypeName());
        XmlSchemaType schemaType = element.getSchemaType();
        if (!this.crossImportsAdded(schema, schemaType)) {
            this.addCrossImportsType(schema, schemaType);
        }
    }

    private boolean crossImportsAdded(XmlSchema schema, XmlSchemaType schemaType) {
        boolean result = true;
        if (schemaType != null) {
            Set<Object> xmlTypesCheckedForCrossImports;
            if (!this.xmlTypesCheckedForCrossImportsPerSchema.containsKey(schema)) {
                xmlTypesCheckedForCrossImports = new HashSet();
                this.xmlTypesCheckedForCrossImportsPerSchema.put(schema, xmlTypesCheckedForCrossImports);
            } else {
                xmlTypesCheckedForCrossImports = this.xmlTypesCheckedForCrossImportsPerSchema.get(schema);
            }
            if (!xmlTypesCheckedForCrossImports.contains(schemaType)) {
                xmlTypesCheckedForCrossImports.add(schemaType);
                result = false;
            }
        }
        return result;
    }

    private void addCrossImportsType(XmlSchema schema, XmlSchemaType schemaType) {
        if (schemaType != null) {
            XmlSchemaUtils.addImportIfNeeded(schema, schemaType.getBaseSchemaTypeName());
            if (schemaType instanceof XmlSchemaComplexType) {
                XmlSchemaComplexType complexType = (XmlSchemaComplexType)schemaType;
                this.addCrossImports(schema, complexType.getContentModel());
                this.addCrossImportsAttributeList(schema, complexType.getAttributes());
                XmlSchemaSequence sequence = XmlSchemaUtils.getSequence(complexType);
                this.addCrossImportsSequence(schema, sequence);
            }
        }
    }

    private void addCrossImportsSequence(XmlSchema schema, XmlSchemaSequence sequence) {
        XmlSchemaObjectCollection items = sequence.getItems();
        for (int x = 0; x < items.getCount(); ++x) {
            XmlSchemaObject seqItem = items.getItem(x);
            if (!(seqItem instanceof XmlSchemaElement)) continue;
            this.addElementCrossImportsElement(schema, seqItem);
        }
    }

    private void addCrossImportsAttributeList(XmlSchema schema, XmlSchemaObjectCollection attributes) {
        for (int x = 0; x < attributes.getCount(); ++x) {
            XmlSchemaAttribute attr = (XmlSchemaAttribute)attributes.getItem(x);
            XmlSchemaUtils.addImportIfNeeded(schema, attr.getRefName());
        }
    }

    private void addCrossImports(XmlSchema schema, XmlSchemaContentModel contentModel) {
        if (contentModel == null) {
            return;
        }
        XmlSchemaContent content = contentModel.getContent();
        if (content == null) {
            return;
        }
        if (content instanceof XmlSchemaComplexContentExtension) {
            XmlSchemaComplexContentExtension extension = (XmlSchemaComplexContentExtension)content;
            XmlSchemaUtils.addImportIfNeeded(schema, extension.getBaseTypeName());
            this.addCrossImportsAttributeList(schema, extension.getAttributes());
            XmlSchemaParticle particle = extension.getParticle();
            if (particle instanceof XmlSchemaSequence) {
                this.addCrossImportsSequence(schema, (XmlSchemaSequence)particle);
            }
        } else if (content instanceof XmlSchemaComplexContentRestriction) {
            XmlSchemaComplexContentRestriction restriction = (XmlSchemaComplexContentRestriction)content;
            XmlSchemaUtils.addImportIfNeeded(schema, restriction.getBaseTypeName());
            this.addCrossImportsAttributeList(schema, restriction.getAttributes());
        } else if (content instanceof XmlSchemaSimpleContentExtension) {
            XmlSchemaSimpleContentExtension extension = (XmlSchemaSimpleContentExtension)content;
            XmlSchemaUtils.addImportIfNeeded(schema, extension.getBaseTypeName());
            this.addCrossImportsAttributeList(schema, extension.getAttributes());
        } else if (content instanceof XmlSchemaSimpleContentRestriction) {
            XmlSchemaSimpleContentRestriction restriction = (XmlSchemaSimpleContentRestriction)content;
            XmlSchemaUtils.addImportIfNeeded(schema, restriction.getBaseTypeName());
            this.addCrossImportsAttributeList(schema, restriction.getAttributes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGlobalElementToSchema(XmlSchema schema, XmlSchemaElement element) {
        XmlSchema xmlSchema = schema;
        synchronized (xmlSchema) {
            schema.getItems().add((XmlSchemaObject)element);
            schema.getElements().add(element.getQName(), (XmlSchemaObject)element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGlobalTypeToSchema(XmlSchema schema, XmlSchemaType type) {
        XmlSchema xmlSchema = schema;
        synchronized (xmlSchema) {
            schema.getItems().add((XmlSchemaObject)type);
            schema.addType(type);
        }
    }

    static {
        Method m = null;
        try {
            m = XmlSchema.class.getMethod("getElementByName", String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GET_ELEMENT_BY_NAME_METHOD = m;
    }
}

