/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.brave;

import brave.http.HttpTracing;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.brave.AbstractBraveClientInterceptor;
import org.apache.cxf.tracing.brave.AbstractBraveInterceptor;
import org.apache.cxf.tracing.brave.TraceScope;

public class BraveClientStartInterceptor
extends AbstractBraveClientInterceptor {
    public BraveClientStartInterceptor(HttpTracing brave) {
        this("pre-stream", brave);
    }

    public BraveClientStartInterceptor(String phase, HttpTracing brave) {
        super(phase, brave);
    }

    public void handleMessage(Message message) throws Fault {
        AbstractBraveInterceptor.ParsedMessage parsed = new AbstractBraveInterceptor.ParsedMessage(message);
        AbstractTracingProvider.TraceScopeHolder<TraceScope> holder = super.startTraceSpan(parsed.getHeaders(), parsed.getUri(), parsed.getHttpMethod());
        if (holder != null) {
            message.getExchange().put((Object)"org.apache.cxf.tracing.client.brave.span", holder);
        }
    }

    @Override
    public void handleFault(Message message) {
        AbstractTracingProvider.TraceScopeHolder holder = (AbstractTracingProvider.TraceScopeHolder)message.getExchange().get((Object)"org.apache.cxf.tracing.client.brave.span");
        Exception ex = (Exception)message.getContent(Exception.class);
        super.stopTraceSpan((AbstractTracingProvider.TraceScopeHolder<TraceScope>)holder, ex);
    }
}

