/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.micrometer;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.micrometer.ObservationScope;

public abstract class AbstractObservationProvider
extends AbstractTracingProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractObservationProvider.class);
    protected static final String OBSERVATION_SCOPE = "org.apache.cxf.tracing.micrometer.observation";
    protected final ObservationRegistry observationRegistry;

    protected AbstractObservationProvider() {
        this(ObservationRegistry.NOOP);
    }

    protected AbstractObservationProvider(ObservationRegistry observationRegistry) {
        this.observationRegistry = observationRegistry;
    }

    protected AbstractTracingProvider.TraceScopeHolder<ObservationScope> startScopedObservation(Observation observation) {
        Observation.Scope scope = null;
        if (this.isAsyncResponse()) {
            this.propagateContinuationSpan(observation);
        } else {
            scope = observation.openScope();
        }
        return new AbstractTracingProvider.TraceScopeHolder((Object)new ObservationScope(observation, scope), scope == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTraceSpan(AbstractTracingProvider.TraceScopeHolder<ObservationScope> holder, Consumer<Observation> addResponse) {
        if (holder == null) {
            return;
        }
        ObservationScope observationScope = (ObservationScope)holder.getScope();
        Observation.Scope scope = null;
        if (observationScope != null) {
            try {
                Observation observation = observationScope.getObservation();
                if (holder.isDetached()) {
                    scope = observation.openScope();
                }
                if (!observation.isNoop()) {
                    addResponse.accept(observation);
                }
            }
            finally {
                if (scope != null) {
                    scope.close();
                }
                observationScope.close();
            }
        }
    }

    protected boolean isAsyncResponse() {
        return !PhaseInterceptorChain.getCurrentMessage().getExchange().isSynchronous();
    }

    private void propagateContinuationSpan(Observation continuationScope) {
        PhaseInterceptorChain.getCurrentMessage().put(Observation.class, (Object)continuationScope);
    }
}

