/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.micrometer.jaxrs;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.lang.annotation.Annotation;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.micrometer.AbstractObservationProvider;
import org.apache.cxf.tracing.micrometer.ObservationScope;
import org.apache.cxf.tracing.micrometer.jaxrs.ContainerRequestReceiverContext;
import org.apache.cxf.tracing.micrometer.jaxrs.ContainerRequestReceiverObservationConvention;
import org.apache.cxf.tracing.micrometer.jaxrs.DefaultContainerRequestReceiverObservationConvention;
import org.apache.cxf.tracing.micrometer.jaxrs.JaxrsObservationDocumentation;

@Provider
public class ObservationProvider
extends AbstractObservationProvider
implements ContainerRequestFilter,
ContainerResponseFilter {
    @Context
    private ResourceInfo resourceInfo;
    private final ContainerRequestReceiverObservationConvention convention;

    public ObservationProvider(ObservationRegistry observationRegistry) {
        this(observationRegistry, null);
    }

    public ObservationProvider(ObservationRegistry observationRegistry, ContainerRequestReceiverObservationConvention convention) {
        super(observationRegistry);
        this.convention = convention;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        ContainerRequestReceiverContext receiverContext = new ContainerRequestReceiverContext(requestContext);
        Observation observation = JaxrsObservationDocumentation.IN_OBSERVATION.start(this.convention, DefaultContainerRequestReceiverObservationConvention.INSTANCE, () -> receiverContext, this.observationRegistry);
        AbstractTracingProvider.TraceScopeHolder<ObservationScope> holder = super.startScopedObservation(observation);
        if (holder != null) {
            requestContext.setProperty("org.apache.cxf.tracing.micrometer.observation", holder);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        super.stopTraceSpan((AbstractTracingProvider.TraceScopeHolder<ObservationScope>)((AbstractTracingProvider.TraceScopeHolder)requestContext.getProperty("org.apache.cxf.tracing.micrometer.observation")), observation -> {
            ContainerRequestReceiverContext context = (ContainerRequestReceiverContext)observation.getContext();
            context.setResponse(responseContext);
        });
    }

    @Override
    protected boolean isAsyncResponse() {
        Annotation[][] annotationArray = this.resourceInfo.getResourceMethod().getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotationArray[i]) {
                if (!annotation.annotationType().equals(Suspended.class)) continue;
                return true;
            }
        }
        return false;
    }
}

