/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.micrometer;

import io.micrometer.common.lang.Nullable;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.micrometer.ObservationScope;

public abstract class AbstractObservationClientProvider
extends AbstractTracingProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractObservationClientProvider.class);
    protected static final String OBSERVATION_SCOPE = "org.apache.cxf.tracing.client.micrometer.observation";
    private final ObservationRegistry observationRegistry;

    public AbstractObservationClientProvider() {
        this(ObservationRegistry.NOOP);
    }

    public AbstractObservationClientProvider(ObservationRegistry observationRegistry) {
        this.observationRegistry = observationRegistry;
    }

    protected AbstractTracingProvider.TraceScopeHolder<ObservationScope> startScopedObservation(Observation observation) {
        Observation.Scope scope = null;
        if (!this.isAsyncInvocation()) {
            scope = observation.openScope();
        }
        return new AbstractTracingProvider.TraceScopeHolder((Object)new ObservationScope(observation, scope), scope == null);
    }

    private boolean isAsyncInvocation() {
        return !PhaseInterceptorChain.getCurrentMessage().getExchange().isSynchronous();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTraceSpan(AbstractTracingProvider.TraceScopeHolder<ObservationScope> holder, @Nullable Exception ex, Consumer<Observation> addResponse) {
        if (holder == null) {
            return;
        }
        ObservationScope observationScope = (ObservationScope)holder.getScope();
        Observation.Scope scope = null;
        if (observationScope != null) {
            try {
                Observation observation = observationScope.getObservation();
                observation.error((Throwable)ex);
                if (holder.isDetached()) {
                    scope = observation.openScope();
                }
                if (!observation.isNoop()) {
                    addResponse.accept(observation);
                }
            }
            finally {
                if (scope != null) {
                    scope.close();
                }
                observationScope.close();
            }
        }
    }

    protected ObservationRegistry getObservationRegistry() {
        return this.observationRegistry;
    }
}

