/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentelemetry.jaxrs;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.opentelemetry.AbstractOpenTelemetryProvider;
import org.apache.cxf.tracing.opentelemetry.TraceScope;

@Provider
public class OpenTelemetryProvider
extends AbstractOpenTelemetryProvider
implements ContainerRequestFilter,
ContainerResponseFilter {
    @Context
    private ResourceInfo resourceInfo;

    public OpenTelemetryProvider(OpenTelemetry openTelemetry, String instrumentationName) {
        super(openTelemetry, instrumentationName);
    }

    public OpenTelemetryProvider(OpenTelemetry openTelemetry, Tracer tracer) {
        super(openTelemetry, tracer);
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        AbstractTracingProvider.TraceScopeHolder<TraceScope> holder = super.startTraceSpan((Map<String, List<String>>)requestContext.getHeaders(), requestContext.getUriInfo().getRequestUri(), requestContext.getMethod());
        if (holder != null) {
            requestContext.setProperty("org.apache.cxf.tracing.opentelemetry.span", holder);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        super.stopTraceSpan((Map<String, List<String>>)requestContext.getHeaders(), (Map<String, List<Object>>)responseContext.getHeaders(), responseContext.getStatus(), (AbstractTracingProvider.TraceScopeHolder<TraceScope>)((AbstractTracingProvider.TraceScopeHolder)requestContext.getProperty("org.apache.cxf.tracing.opentelemetry.span")));
    }

    @Override
    protected boolean isAsyncResponse() {
        Annotation[][] annotationArray = this.resourceInfo.getResourceMethod().getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotationArray[i]) {
                if (!annotation.annotationType().equals(Suspended.class)) continue;
                return true;
            }
        }
        return false;
    }
}

