/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentelemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.opentelemetry.AbstractOpenTelemetryClientInterceptor;
import org.apache.cxf.tracing.opentelemetry.TraceScope;

public class OpenTelemetryClientStartInterceptor
extends AbstractOpenTelemetryClientInterceptor {
    public OpenTelemetryClientStartInterceptor(OpenTelemetry openTelemetry, String instrumentationName) {
        this("pre-stream", openTelemetry, instrumentationName);
    }

    public OpenTelemetryClientStartInterceptor(OpenTelemetry openTelemetry, Tracer tracer) {
        this("pre-stream", openTelemetry, tracer);
    }

    public OpenTelemetryClientStartInterceptor(String phase, OpenTelemetry openTelemetry, String instrumentationName) {
        super(phase, openTelemetry, instrumentationName);
    }

    public OpenTelemetryClientStartInterceptor(String phase, OpenTelemetry openTelemetry, Tracer tracer) {
        super(phase, openTelemetry, tracer);
    }

    public void handleMessage(Message message) throws Fault {
        Map headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        AbstractTracingProvider.TraceScopeHolder<TraceScope> holder = super.startTraceSpan(headers, OpenTelemetryClientStartInterceptor.getUri((Message)message), (String)message.get((Object)"org.apache.cxf.request.method"));
        if (holder != null) {
            message.getExchange().put((Object)"org.apache.cxf.tracing.client.opentelemetry.span", holder);
        }
    }

    @Override
    public void handleFault(Message message) {
        AbstractTracingProvider.TraceScopeHolder holder = (AbstractTracingProvider.TraceScopeHolder)message.getExchange().get((Object)"org.apache.cxf.tracing.client.opentelemetry.span");
        Exception ex = (Exception)message.getContent(Exception.class);
        super.stopTraceSpan((AbstractTracingProvider.TraceScopeHolder<TraceScope>)holder, ex);
    }
}

