/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentracing.jaxrs;

import io.opentracing.Tracer;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.opentracing.AbstractOpenTracingClientProvider;
import org.apache.cxf.tracing.opentracing.TraceScope;

@Provider
public class OpenTracingClientProvider
extends AbstractOpenTracingClientProvider
implements ClientRequestFilter,
ClientResponseFilter {
    public OpenTracingClientProvider(Tracer tracer) {
        super(tracer);
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        AbstractTracingProvider.TraceScopeHolder<TraceScope> holder = super.startTraceSpan((Map<String, List<String>>)requestContext.getStringHeaders(), requestContext.getUri(), requestContext.getMethod());
        if (holder != null) {
            requestContext.setProperty("org.apache.cxf.tracing.client.opentracing.span", holder);
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        AbstractTracingProvider.TraceScopeHolder holder = (AbstractTracingProvider.TraceScopeHolder)requestContext.getProperty("org.apache.cxf.tracing.client.opentracing.span");
        super.stopTraceSpan((AbstractTracingProvider.TraceScopeHolder<TraceScope>)holder, responseContext.getStatus());
    }
}

