/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentracing.jaxrs;

import io.opentracing.Tracer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.opentracing.AbstractOpenTracingProvider;
import org.apache.cxf.tracing.opentracing.TraceScope;

@Provider
public class OpenTracingProvider
extends AbstractOpenTracingProvider
implements ContainerRequestFilter,
ContainerResponseFilter {
    @Context
    private ResourceInfo resourceInfo;

    public OpenTracingProvider(Tracer tracer) {
        super(tracer);
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        AbstractTracingProvider.TraceScopeHolder<TraceScope> holder = super.startTraceSpan((Map<String, List<String>>)requestContext.getHeaders(), requestContext.getUriInfo().getRequestUri(), requestContext.getMethod());
        if (holder != null) {
            requestContext.setProperty("org.apache.cxf.tracing.opentracing.span", holder);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        super.stopTraceSpan((Map<String, List<String>>)requestContext.getHeaders(), (Map<String, List<Object>>)responseContext.getHeaders(), responseContext.getStatus(), (AbstractTracingProvider.TraceScopeHolder<TraceScope>)((AbstractTracingProvider.TraceScopeHolder)requestContext.getProperty("org.apache.cxf.tracing.opentracing.span")));
    }

    @Override
    protected boolean isAsyncResponse() {
        Annotation[][] annotationArray = this.resourceInfo.getResourceMethod().getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotationArray[i]) {
                if (!annotation.annotationType().equals(Suspended.class)) continue;
                return true;
            }
        }
        return false;
    }
}

