/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.saaj;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.common.util.StringUtils;

public final class SAAJUtils {
    private SAAJUtils() {
    }

    public static SOAPHeader getHeader(SOAPMessage m) throws SOAPException {
        try {
            return m.getSOAPHeader();
        }
        catch (UnsupportedOperationException ex) {
            return m.getSOAPPart().getEnvelope().getHeader();
        }
    }

    public static SOAPBody getBody(SOAPMessage m) throws SOAPException {
        try {
            return m.getSOAPBody();
        }
        catch (UnsupportedOperationException ex) {
            return m.getSOAPPart().getEnvelope().getBody();
        }
    }

    public static void setFaultCode(SOAPFault f, QName code) throws SOAPException {
        try {
            f.setFaultCode(code);
        }
        catch (Throwable t) {
            int count = 1;
            String pfx = "fc1";
            while (!StringUtils.isEmpty((String)f.getNamespaceURI(pfx))) {
                pfx = "fc" + ++count;
            }
            f.addNamespaceDeclaration(pfx, code.getNamespaceURI());
            f.setFaultCode(pfx + ":" + code.getLocalPart());
        }
    }

    public static SOAPElement adjustPrefix(SOAPElement e, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        try {
            String s = e.getPrefix();
            if (!prefix.equals(s)) {
                e.setPrefix(prefix);
                e.removeNamespaceDeclaration(s);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return e;
    }
}

