/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jibx;

import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.jibx.JibxDataBinding;
import org.apache.cxf.jibx.JibxSimpleTypes;
import org.apache.cxf.service.ServiceModelVisitor;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.JiBXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JibxSchemaInitializer
extends ServiceModelVisitor {
    private static final Logger LOG = LogUtils.getLogger(JibxSchemaInitializer.class);
    private SchemaCollection schemas;

    public JibxSchemaInitializer(ServiceInfo serviceInfo, SchemaCollection schemas, JibxDataBinding databinding) {
        super(serviceInfo);
        this.schemas = schemas;
    }

    public void begin(MessagePartInfo part) {
        LOG.finest(part.getName().toString());
        if (part.getTypeQName() != null || part.getElementQName() != null) {
            this.checkForExistence(part);
            return;
        }
        Class<?> clazz = part.getTypeClass();
        if (clazz == null) {
            return;
        }
        boolean isFromWrapper = part.getMessageInfo().getOperation().isUnwrapped();
        if (isFromWrapper && clazz.isArray() && !Byte.TYPE.equals(clazz.getComponentType())) {
            clazz = clazz.getComponentType();
        }
        this.mapClass(part, clazz);
    }

    public void checkForExistence(MessagePartInfo part) {
        XmlSchemaElement el;
        QName qn = part.getElementQName();
        if (qn != null && (el = this.schemas.getElementByQName(qn)) == null) {
            Class<?> clazz = part.getTypeClass();
            if (clazz == null) {
                return;
            }
            boolean isFromWrapper = part.getMessageInfo().getOperation().isUnwrapped();
            if (isFromWrapper && clazz.isArray() && !Byte.TYPE.equals(clazz.getComponentType())) {
                clazz = clazz.getComponentType();
            }
            this.mapClass(part, clazz);
        }
    }

    private void mapClass(MessagePartInfo part, Class<?> clazz) {
        if (JibxSimpleTypes.isSimpleType(clazz)) {
            QName schemaType = JibxSimpleTypes.schemaType(clazz);
            part.setTypeQName(schemaType);
            part.setXmlSchema((XmlSchemaAnnotated)this.schemas.getTypeByQName(schemaType));
        } else {
            try {
                IBindingFactory factory = BindingDirectory.getFactory(clazz);
                String[][] abstractMappings = factory.getAbstractMappings();
                String stype = abstractMappings[0][0];
                QName qName = JibxSimpleTypes.toQname(stype);
                XmlSchema schema = this.schemas.getSchemaForElement(qName);
                if (schema != null) {
                    XmlSchemaElement element = schema.getElementByName(qName);
                    part.setXmlSchema((XmlSchemaAnnotated)element);
                    part.setElementQName(qName);
                    part.setConcreteName(qName);
                    part.setElement(true);
                }
            }
            catch (JiBXException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

