/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.spring;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.configuration.spring.BusWiringType;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxws.EndpointImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EndpointDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String IMPLEMENTOR = "implementor";

    public EndpointDefinitionParser() {
        this.setBeanClass(SpringEndpointImpl.class);
    }

    protected String getSuffix() {
        return ".jaxws-endpoint";
    }

    protected void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        boolean isAbstract = false;
        NamedNodeMap atts = element.getAttributes();
        String bus = element.getAttribute("bus");
        if (StringUtils.isEmpty((String)bus)) {
            this.addBusWiringAttribute(bean, BusWiringType.CONSTRUCTOR);
        } else {
            bean.addConstructorArgReference(bus);
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr node = (Attr)atts.item(i);
            String val = node.getValue();
            String pre = node.getPrefix();
            String name = node.getLocalName();
            if ("createdFromAPI".equals(name)) {
                bean.setAbstract(true);
                isAbstract = true;
                continue;
            }
            if (this.isAttribute(pre, name) && !"publish".equals(name) && !"bus".equals(name)) {
                if ("endpointName".equals(name) || "serviceName".equals(name)) {
                    QName q = this.parseQName(element, val);
                    bean.addPropertyValue(name, (Object)q);
                    continue;
                }
                if ("depends-on".equals(name)) {
                    bean.addDependsOn(val);
                    continue;
                }
                if (IMPLEMENTOR.equals(name)) {
                    this.loadImplementor(bean, val);
                    continue;
                }
                if ("name".equals(name)) continue;
                this.mapToProperty(bean, name, val);
                continue;
            }
            if (!"abstract".equals(name)) continue;
            bean.setAbstract(true);
            isAbstract = true;
        }
        Element elem = DOMUtils.getFirstElement((Node)element);
        while (elem != null) {
            String name = elem.getLocalName();
            if ("properties".equals(name)) {
                Map map = ctx.getDelegate().parseMapElement(elem, (BeanDefinition)bean.getBeanDefinition());
                bean.addPropertyValue("properties", (Object)map);
            } else if ("binding".equals(name)) {
                this.setFirstChildAsProperty(elem, ctx, bean, "bindingConfig");
            } else if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name) || "features".equals(name) || "schemaLocations".equals(name) || "handlers".equals(name)) {
                List list = ctx.getDelegate().parseListElement(elem, (BeanDefinition)bean.getBeanDefinition());
                bean.addPropertyValue(name, (Object)list);
            } else if (IMPLEMENTOR.equals(name)) {
                ctx.getDelegate().parseConstructorArgElement(elem, (BeanDefinition)bean.getBeanDefinition());
            } else {
                this.setFirstChildAsProperty(elem, ctx, bean, name);
            }
            elem = DOMUtils.getNextElement((Element)elem);
        }
        if (!isAbstract) {
            bean.setInitMethodName("publish");
            bean.setDestroyMethodName("stop");
        }
        bean.setLazyInit(false);
    }

    private void loadImplementor(BeanDefinitionBuilder bean, String val) {
        if (!StringUtils.isEmpty((String)val)) {
            if (val.startsWith("#")) {
                bean.addConstructorArgReference(val.substring(1));
            } else {
                try {
                    Object obj = ClassLoaderUtils.loadClass((String)val, ((Object)((Object)this)).getClass()).newInstance();
                    bean.addConstructorArg(obj);
                }
                catch (Exception e) {
                    throw new FatalBeanException("Could not load class: " + val, (Throwable)e);
                }
            }
        }
    }

    protected String resolveId(Element elem, AbstractBeanDefinition definition, ParserContext ctx) throws BeanDefinitionStoreException {
        String id = super.resolveId(elem, definition, ctx);
        if (StringUtils.isEmpty((String)id)) {
            id = EndpointImpl.class.getName() + "--" + definition.hashCode();
        }
        return id;
    }

    public static class SpringEndpointImpl
    extends EndpointImpl
    implements ApplicationContextAware {
        public SpringEndpointImpl(Object implementor) {
            super(null, implementor);
        }

        public SpringEndpointImpl(Bus bus, Object implementor) {
            super(bus, implementor);
        }

        public void setApplicationContext(ApplicationContext ctx) throws BeansException {
            if (this.getBus() == null) {
                Bus bus = BusFactory.getThreadDefaultBus();
                BusWiringBeanFactoryPostProcessor.updateBusReferencesInContext((Bus)bus, (ApplicationContext)ctx);
                this.setBus(bus);
            }
        }
    }
}

