/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.reactivestreams.server;

import jakarta.ws.rs.container.AsyncResponse;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.apache.cxf.jaxrs.ext.StreamingResponse;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class AbstractSubscriber<T>
implements Subscriber<T> {
    private AsyncResponse ar;
    private Subscription subscription;

    protected AbstractSubscriber(AsyncResponse ar) {
        this.ar = ar;
    }

    public void resume(T response) {
        this.ar.resume(response);
    }

    public void resume(List<T> response) {
        this.ar.resume(response);
    }

    public void resume(StreamingResponse<T> response) {
        this.ar.resume(response);
    }

    public void onError(Throwable t) {
        if (t instanceof CancellationException) {
            this.ar.cancel();
        } else {
            this.ar.resume(t);
        }
    }

    public void onSubscribe(Subscription inSubscription) {
        this.subscription = inSubscription;
        this.requestAll();
    }

    public void onNext(T t) {
        this.resume(t);
    }

    public void onComplete() {
    }

    protected AsyncResponse getAsyncResponse() {
        return this.ar;
    }

    protected Subscription getSubscription() {
        return this.subscription;
    }

    protected void requestNext() {
        this.request(1L);
    }

    protected void requestAll() {
        this.request(Long.MAX_VALUE);
    }

    protected final void request(long elements) {
        this.subscription.request(elements);
    }
}

