/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.reactor.client;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Supplier;

final class ReactorUtils {
    static final String TRACE = "TRACE";

    private ReactorUtils() {
    }

    static <R> CompletableFuture<R> toCompletableFuture(Future<R> future, Executor executor) {
        Supplier<Object> supplier = () -> {
            try {
                return future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new CompletionException(e);
            }
        };
        if (executor != null) {
            return CompletableFuture.supplyAsync(supplier, executor);
        }
        return CompletableFuture.supplyAsync(supplier);
    }
}

