/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.annotation.ClientHeaderParam;

final class Validator {
    private static final Logger LOG = LogUtils.getL7dLogger(Validator.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(Validator.class);

    private Validator() {
    }

    public static void checkValid(Class<?> userType) throws RestClientDefinitionException {
        if (!userType.isInterface()) {
            Validator.throwException("VALIDATION_NOT_AN_INTERFACE", userType);
        }
        Method[] methods = userType.getMethods();
        Validator.checkMethodsForMultipleHTTPMethodAnnotations(methods);
        Validator.checkMethodsForInvalidURITemplates(userType, methods);
        Validator.checkForInvalidClientHeaderParams(userType, methods);
    }

    private static void checkMethodsForMultipleHTTPMethodAnnotations(Method[] clientMethods) throws RestClientDefinitionException {
        HashMap<String, Class<? extends Annotation>> httpMethods = new HashMap<String, Class<? extends Annotation>>();
        for (Method method : clientMethods) {
            for (Annotation anno : method.getAnnotations()) {
                Class<? extends Annotation> annoClass = anno.annotationType();
                HttpMethod verb = annoClass.getAnnotation(HttpMethod.class);
                if (verb == null) continue;
                httpMethods.put(verb.value(), annoClass);
            }
            if (httpMethods.size() > 1) {
                Validator.throwException("VALIDATION_METHOD_WITH_MULTIPLE_VERBS", method, httpMethods.values());
            }
            httpMethods.clear();
        }
    }

    private static void checkMethodsForInvalidURITemplates(Class<?> userType, Method[] methods) throws RestClientDefinitionException {
        Path classPathAnno = userType.getAnnotation(Path.class);
        HashSet classLevelVariables = new HashSet();
        URITemplate classTemplate = null;
        if (classPathAnno != null) {
            classTemplate = new URITemplate(classPathAnno.value());
            classLevelVariables.addAll(classTemplate.getVariables());
        }
        for (Method method : methods) {
            PathParam pathParam;
            Path methodPathAnno = method.getAnnotation(Path.class);
            URITemplate template = methodPathAnno != null ? (classPathAnno == null ? new URITemplate(methodPathAnno.value()) : new URITemplate(classPathAnno.value() + "/" + methodPathAnno.value())) : classTemplate;
            if (template == null) continue;
            HashSet allVariables = new HashSet(template.getVariables());
            if (!allVariables.isEmpty()) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                for (Parameter p : method.getParameters()) {
                    pathParam = p.getAnnotation(PathParam.class);
                    if (pathParam == null) continue;
                    paramMap.put(pathParam.value(), "x");
                }
                try {
                    template.substitute(paramMap, Collections.emptySet(), false);
                }
                catch (IllegalArgumentException ex) {
                    Validator.throwException("VALIDATION_UNRESOLVED_PATH_PARAMS", userType, method);
                }
                continue;
            }
            ArrayList<String> foundParams = new ArrayList<String>();
            for (Parameter p : method.getParameters()) {
                pathParam = p.getAnnotation(PathParam.class);
                if (pathParam == null) continue;
                foundParams.add(pathParam.value());
            }
            if (foundParams.isEmpty()) continue;
            Validator.throwException("VALIDATION_EXTRA_PATH_PARAMS", userType, method);
        }
    }

    private static void checkForInvalidClientHeaderParams(Class<?> userType, Method[] methods) {
        ClientHeaderParam[] interfaceAnnotations = (ClientHeaderParam[])userType.getAnnotationsByType(ClientHeaderParam.class);
        Validator.checkClientHeaderParamAnnotation(interfaceAnnotations, userType, methods);
        for (Method method : methods) {
            ClientHeaderParam[] methodAnnotations = (ClientHeaderParam[])method.getAnnotationsByType(ClientHeaderParam.class);
            Validator.checkClientHeaderParamAnnotation(methodAnnotations, userType, methods);
        }
    }

    private static void checkClientHeaderParamAnnotation(ClientHeaderParam[] annos, Class<?> userType, Method[] methods) {
        HashSet<String> headerNames = new HashSet<String>();
        for (ClientHeaderParam anno : annos) {
            String[] values;
            String name = anno.name();
            if (headerNames.contains(name)) {
                Validator.throwException("CLIENT_HEADER_MULTIPLE_SAME_HEADER_NAMES", userType.getName());
            }
            headerNames.add(name);
            if (name == null || "".equals(name)) {
                Validator.throwException("CLIENT_HEADER_NO_NAME", userType.getName());
            }
            for (String value : values = anno.value()) {
                if (StringUtils.isEmpty((String)value)) {
                    Validator.throwException("CLIENT_HEADER_NO_VALUE", userType.getName());
                }
                if (!value.startsWith("{") || !value.endsWith("}")) continue;
                if (values.length > 1) {
                    Validator.throwException("CLIENT_HEADER_MULTI_METHOD", userType.getName());
                }
                String computeValue = value.substring(1, value.length() - 1);
                boolean usingOtherClass = false;
                if (computeValue.contains(".")) {
                    usingOtherClass = true;
                    String className = computeValue.substring(0, computeValue.lastIndexOf(46));
                    computeValue = computeValue.substring(computeValue.lastIndexOf(46) + 1);
                    try {
                        Class computeClass = ClassLoaderUtils.loadClass((String)className, userType);
                        methods = (Method[])Arrays.stream(computeClass.getDeclaredMethods()).filter(m -> {
                            int i = m.getModifiers();
                            return Modifier.isPublic(i) && Modifier.isStatic(i);
                        }).toArray(Method[]::new);
                    }
                    catch (ClassNotFoundException ex) {
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.log(Level.FINEST, "Unable to load specified compute method class", ex);
                        }
                        Validator.throwException("CLIENT_HEADER_COMPUTE_CLASS_NOT_FOUND", userType.getName(), ex);
                    }
                }
                boolean foundMatchingMethod = false;
                for (Method method : methods) {
                    Class<?>[] args;
                    Class<?> returnType = method.getReturnType();
                    if (!usingOtherClass && !method.isDefault() || !String.class.equals(returnType) && !String[].class.equals(returnType) || !computeValue.equals(method.getName()) || (args = method.getParameterTypes()).length != 0 && (args.length != 1 || !String.class.equals(args[0]))) continue;
                    foundMatchingMethod = true;
                    break;
                }
                if (foundMatchingMethod) continue;
                Validator.throwException("CLIENT_HEADER_INVALID_COMPUTE_METHOD", userType.getName(), computeValue);
            }
        }
    }

    private static void throwException(String msgKey, Object ... msgParams) throws RestClientDefinitionException {
        Message msg = new Message(msgKey, BUNDLE, msgParams);
        throw new RestClientDefinitionException(msg.toString());
    }
}

