/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJweJsonWriterProvider;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweJsonProducer;

@Priority(value=1001)
public class JweJsonWriterInterceptor
extends AbstractJweJsonWriterProvider
implements WriterInterceptor {
    private boolean contentTypeRequired = true;
    private boolean useJweOutputStream;

    public void aroundWriteTo(WriterInterceptorContext ctx) throws IOException, WebApplicationException {
        if (ctx.getEntity() == null) {
            ctx.proceed();
            return;
        }
        OutputStream actualOs = ctx.getOutputStream();
        List<JweEncryptionProvider> providers = this.getInitializedEncryptionProviders();
        String ctString = null;
        MediaType contentMediaType = ctx.getMediaType();
        if (this.contentTypeRequired && contentMediaType != null) {
            ctString = "application".equals(contentMediaType.getType()) ? contentMediaType.getSubtype() : JAXRSUtils.mediaTypeToString((MediaType)contentMediaType, (String[])new String[0]);
        }
        JweHeaders protectedHeaders = new JweHeaders(ContentAlgorithm.A128GCM);
        if (ctString != null) {
            protectedHeaders.setContentType(ctString);
        }
        ArrayList<KeyAlgorithm> keyAlgos = new ArrayList<KeyAlgorithm>();
        for (JweEncryptionProvider p : providers) {
            if (keyAlgos.contains(p.getKeyAlgorithm())) continue;
            keyAlgos.add(p.getKeyAlgorithm());
        }
        ArrayList<JweHeaders> perRecipientUnprotectedHeaders = null;
        if (keyAlgos.size() == 1) {
            protectedHeaders.setKeyEncryptionAlgorithm((KeyAlgorithm)keyAlgos.get(0));
        } else {
            perRecipientUnprotectedHeaders = new ArrayList<JweHeaders>();
            for (KeyAlgorithm keyAlgo : keyAlgos) {
                JweHeaders headers = new JweHeaders();
                headers.setKeyEncryptionAlgorithm(keyAlgo);
                perRecipientUnprotectedHeaders.add(headers);
            }
        }
        if (!this.useJweOutputStream) {
            CachedOutputStream cos = new CachedOutputStream();
            ctx.setOutputStream((OutputStream)cos);
            ctx.proceed();
            JweJsonProducer producer = new JweJsonProducer(protectedHeaders, cos.getBytes());
            String jweContent = producer.encryptWith(providers, perRecipientUnprotectedHeaders);
            this.setJoseMediaType(ctx);
            IOUtils.copy((InputStream)new ByteArrayInputStream(StringUtils.toBytesUTF8((String)jweContent)), (OutputStream)actualOs);
            actualOs.flush();
        }
    }

    private void setJoseMediaType(WriterInterceptorContext ctx) {
        MediaType joseMediaType = JAXRSUtils.toMediaType((String)"application/jose+json");
        ctx.setMediaType(joseMediaType);
    }

    public void setUseJweOutputStream(boolean useJweOutputStream) {
        this.useJweOutputStream = useJweOutputStream;
    }
}

