/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.IOException;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.jose.common.JoseException;
import org.apache.cxf.rs.security.jose.jaxrs.JwtTokenSecurityContext;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwt.JoseJwtConsumer;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtUtils;
import org.apache.cxf.security.SecurityContext;

@PreMatching
@Priority(value=1000)
public class JwtAuthenticationFilter
extends JoseJwtConsumer
implements ContainerRequestFilter {
    protected static final Logger LOG = LogUtils.getL7dLogger(JwtAuthenticationFilter.class);
    private static final String DEFAULT_AUTH_SCHEME = "JWT";
    private String expectedAuthScheme = "JWT";
    private int clockOffset;
    private String roleClaim;
    private int ttl;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String[] parts;
        String auth = requestContext.getHeaderString("Authorization");
        String[] stringArray = parts = auth == null ? null : auth.split(" ");
        if (parts == null || !this.expectedAuthScheme.equals(parts[0]) || parts.length != 2) {
            throw new JoseException(this.expectedAuthScheme + " scheme is expected");
        }
        JwtToken token = super.getJwtToken(parts[1]);
        SecurityContext securityContext = this.configureSecurityContext(token);
        if (securityContext != null) {
            JAXRSUtils.getCurrentMessage().put(SecurityContext.class, (Object)securityContext);
        }
    }

    protected SecurityContext configureSecurityContext(JwtToken jwt) {
        Message m = JAXRSUtils.getCurrentMessage();
        boolean enableUnsignedJwt = MessageUtils.getContextualBoolean((Message)m, (String)"rs.security.enable.unsigned-jwt.principal", (boolean)false);
        if (jwt.getClaims().getSubject() != null && (this.isVerifiedWithAPublicKey(jwt) || enableUnsignedJwt)) {
            return new JwtTokenSecurityContext(jwt, this.roleClaim);
        }
        return null;
    }

    private boolean isVerifiedWithAPublicKey(JwtToken jwt) {
        if (this.isJwsRequired()) {
            String alg = (String)jwt.getJwsHeader("alg");
            SignatureAlgorithm sigAlg = SignatureAlgorithm.getAlgorithm((String)alg);
            return SignatureAlgorithm.isPublicKeyAlgorithm((SignatureAlgorithm)sigAlg);
        }
        return false;
    }

    public void setExpectedAuthScheme(String expectedAuthScheme) {
        this.expectedAuthScheme = expectedAuthScheme;
    }

    protected void validateToken(JwtToken jwt) {
        JwtUtils.validateTokenClaims((JwtClaims)jwt.getClaims(), (int)this.ttl, (int)this.clockOffset, (boolean)true);
    }

    public int getClockOffset() {
        return this.clockOffset;
    }

    public void setClockOffset(int clockOffset) {
        this.clockOffset = clockOffset;
    }

    public String getRoleClaim() {
        return this.roleClaim;
    }

    public void setRoleClaim(String roleClaim) {
        this.roleClaim = roleClaim;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }
}

