/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth.filters;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuthProblemException;
import net.oauth.server.OAuthServlet;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.rs.security.oauth.data.OAuthContext;
import org.apache.cxf.rs.security.oauth.filters.AbstractAuthFilter;
import org.apache.cxf.rs.security.oauth.filters.OAuthInfo;
import org.apache.cxf.rs.security.oauth.utils.OAuthUtils;
import org.apache.cxf.security.SecurityContext;

public class OAuthServletFilter
extends AbstractAuthFilter
implements Filter {
    protected static final String USE_USER_SUBJECT = "org.apache.cxf.rs.security.oauth.use_user_subject";

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext servletContext = filterConfig.getServletContext();
        super.setDataProvider(OAuthUtils.getOAuthDataProvider(servletContext));
        super.setValidator(OAuthUtils.getOAuthValidator(servletContext));
        super.setUseUserSubject(PropertyUtils.isTrue((Object)servletContext.getInitParameter(USE_USER_SUBJECT)));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        try {
            OAuthInfo info = this.handleOAuthRequest(req);
            req = this.setSecurityContext(req, info);
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
        catch (OAuthProblemException e) {
            OAuthServlet.handleException((HttpServletResponse)resp, (Exception)((Object)e), (String)"");
        }
        catch (Exception e) {
            OAuthServlet.handleException((HttpServletResponse)resp, (Exception)e, (String)"");
        }
    }

    protected HttpServletRequest setSecurityContext(HttpServletRequest request, OAuthInfo info) {
        final SecurityContext sc = this.createSecurityContext(request, info);
        HttpServletRequestWrapper newRequest = new HttpServletRequestWrapper(request){

            public Principal getUserPrincipal() {
                return sc.getUserPrincipal();
            }

            public boolean isUserInRole(String role) {
                return sc.isUserInRole(role);
            }

            public String getAuthType() {
                return "OAuth";
            }
        };
        newRequest.setAttribute(OAuthContext.class.getName(), (Object)this.createOAuthContext(info));
        return newRequest;
    }

    public void destroy() {
    }
}

