/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.provider;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.DiskStoreConfiguration;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.provider.AbstractOAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.ClientRegistrationProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.refresh.RefreshToken;
import org.apache.cxf.rs.security.oauth2.utils.EHCacheUtil;

public class DefaultEHCacheOAuthDataProvider
extends AbstractOAuthDataProvider
implements ClientRegistrationProvider {
    public static final String CLIENT_CACHE_KEY = "cxf.oauth2.client.cache";
    public static final String ACCESS_TOKEN_CACHE_KEY = "cxf.oauth2.accesstoken.cache";
    public static final String REFRESH_TOKEN_CACHE_KEY = "cxf.oauth2.refreshtoken.cache";
    public static final String DEFAULT_CONFIG_URL = "cxf-oauth2-ehcache.xml";
    protected CacheManager cacheManager;
    private Ehcache clientCache;
    private Ehcache accessTokenCache;
    private Ehcache refreshTokenCache;

    public DefaultEHCacheOAuthDataProvider() {
        this(DEFAULT_CONFIG_URL, BusFactory.getThreadDefaultBus((boolean)true));
    }

    public DefaultEHCacheOAuthDataProvider(String configFileURL, Bus bus) {
        this(configFileURL, bus, CLIENT_CACHE_KEY, ACCESS_TOKEN_CACHE_KEY, REFRESH_TOKEN_CACHE_KEY);
    }

    public DefaultEHCacheOAuthDataProvider(String configFileURL, Bus bus, String clientCacheKey, String accessTokenKey, String refreshTokenKey) {
        this.createCaches(configFileURL, bus, clientCacheKey, accessTokenKey, refreshTokenKey);
    }

    @Override
    public Client getClient(String clientId) throws OAuthServiceException {
        return DefaultEHCacheOAuthDataProvider.getCacheValue(this.clientCache, clientId, Client.class);
    }

    @Override
    public void setClient(Client client) {
        DefaultEHCacheOAuthDataProvider.putCacheValue(this.clientCache, client.getClientId(), client, 0L);
    }

    public void setClients(List<Client> clients) {
        if (clients != null) {
            for (Client client : clients) {
                this.setClient(client);
            }
        }
    }

    @Override
    public Client removeClient(String clientId) {
        Client c = this.getClient(clientId);
        this.clientCache.remove((Serializable)((Object)clientId));
        return c;
    }

    @Override
    public List<Client> getClients() {
        List keys = CastUtils.cast((List)this.clientCache.getKeys());
        ArrayList<Client> clients = new ArrayList<Client>(keys.size());
        for (String key : keys) {
            clients.add(this.getClient(key));
        }
        return clients;
    }

    @Override
    public ServerAccessToken getAccessToken(String accessToken) throws OAuthServiceException {
        return DefaultEHCacheOAuthDataProvider.getCacheValue(this.accessTokenCache, accessToken, ServerAccessToken.class);
    }

    @Override
    public void removeAccessToken(ServerAccessToken accessToken) throws OAuthServiceException {
        this.revokeAccessToken(accessToken.getTokenKey());
    }

    @Override
    protected boolean revokeAccessToken(String accessTokenKey) {
        return this.accessTokenCache.remove((Serializable)((Object)accessTokenKey));
    }

    @Override
    protected RefreshToken revokeRefreshToken(Client client, String refreshTokenKey) {
        RefreshToken refreshToken = DefaultEHCacheOAuthDataProvider.getCacheValue(this.refreshTokenCache, refreshTokenKey, RefreshToken.class);
        if (refreshToken != null) {
            this.refreshTokenCache.remove((Serializable)((Object)refreshTokenKey));
        }
        return refreshToken;
    }

    @Override
    protected void saveAccessToken(ServerAccessToken serverToken) {
        DefaultEHCacheOAuthDataProvider.putCacheValue(this.accessTokenCache, serverToken.getTokenKey(), serverToken, serverToken.getExpiresIn());
    }

    @Override
    protected void saveRefreshToken(ServerAccessToken at, RefreshToken refreshToken) {
        DefaultEHCacheOAuthDataProvider.putCacheValue(this.refreshTokenCache, refreshToken.getTokenKey(), refreshToken, refreshToken.getExpiresIn());
    }

    protected static <T> T getCacheValue(Ehcache cache, String key, Class<T> cls) {
        Element e = cache.get((Serializable)((Object)key));
        if (e != null) {
            return cls.cast(e.getObjectValue());
        }
        return null;
    }

    protected static void putCacheValue(Ehcache cache, String key, Object value, long ttl) {
        Element element = new Element((Object)key, value);
        int parsedTTL = (int)ttl;
        if (ttl != (long)parsedTTL) {
            throw new OAuthServiceException("Requested time to live can not be supported");
        }
        element.setTimeToLive(parsedTTL);
        element.setTimeToIdle(parsedTTL);
        cache.put(element);
    }

    private static CacheManager createCacheManager(String configFile, Bus bus) {
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus((boolean)true);
        }
        URL configFileURL = null;
        try {
            configFileURL = ResourceUtils.getClasspathResourceURL((String)configFile, DefaultEHCacheOAuthDataProvider.class, (Bus)bus);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CacheManager cacheManager = null;
        if (configFileURL == null) {
            cacheManager = EHCacheUtil.createCacheManager();
        } else {
            Configuration conf = ConfigurationFactory.parseConfiguration((URL)configFileURL);
            if (bus != null) {
                conf.setName(bus.getId());
                DiskStoreConfiguration dsc = conf.getDiskStoreConfiguration();
                if (dsc != null && "java.io.tmpdir".equals(dsc.getOriginalPath())) {
                    String path = conf.getDiskStoreConfiguration().getPath() + File.separator + bus.getId();
                    conf.getDiskStoreConfiguration().setPath(path);
                }
            }
            cacheManager = EHCacheUtil.createCacheManager(conf);
        }
        return cacheManager;
    }

    protected static Ehcache createCache(CacheManager cacheManager, String cacheKey) {
        CacheConfiguration clientCC = EHCacheUtil.getCacheConfiguration(cacheKey, cacheManager);
        return cacheManager.addCacheIfAbsent((Ehcache)new Cache(clientCC));
    }

    private void createCaches(String configFile, Bus bus, String clientCacheKey, String accessTokenKey, String refreshTokenKey) {
        this.cacheManager = DefaultEHCacheOAuthDataProvider.createCacheManager(configFile, bus);
        this.clientCache = DefaultEHCacheOAuthDataProvider.createCache(this.cacheManager, clientCacheKey);
        this.accessTokenCache = DefaultEHCacheOAuthDataProvider.createCache(this.cacheManager, accessTokenKey);
        this.refreshTokenCache = DefaultEHCacheOAuthDataProvider.createCache(this.cacheManager, refreshTokenKey);
    }

    public void close() {
        this.cacheManager.shutdown();
    }
}

