/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.saml.SAMLUtils;
import org.apache.cxf.rs.security.saml.assertion.Subject;
import org.apache.cxf.rs.security.saml.sso.AbstractSSOSpHandler;
import org.apache.cxf.rs.security.saml.sso.AuthnRequestBuilder;
import org.apache.cxf.rs.security.saml.sso.DefaultAuthnRequestBuilder;
import org.apache.cxf.rs.security.saml.sso.SamlRequestInfo;
import org.apache.cxf.rs.security.saml.sso.state.RequestState;
import org.apache.cxf.rs.security.saml.sso.state.ResponseState;
import org.apache.cxf.rt.security.claims.ClaimCollection;
import org.apache.cxf.rt.security.saml.claims.SAMLSecurityContext;
import org.apache.cxf.rt.security.utils.SecurityUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@PreMatching
@Priority(value=1001)
public abstract class AbstractServiceProviderFilter
extends AbstractSSOSpHandler
implements ContainerRequestFilter {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractServiceProviderFilter.class);
    protected static final ResourceBundle BUNDLE = BundleUtils.getBundle(AbstractServiceProviderFilter.class);
    private String idpServiceAddress;
    private String issuerId;
    private String assertionConsumerServiceAddress;
    private AuthnRequestBuilder authnRequestBuilder = new DefaultAuthnRequestBuilder();
    private boolean signRequest;
    private String webAppDomain;
    private boolean addWebAppContext = true;
    private boolean addEndpointAddressToContext;

    public void setAddEndpointAddressToContext(boolean add) {
        this.addEndpointAddressToContext = add;
    }

    public void setSignRequest(boolean signRequest) {
        this.signRequest = signRequest;
    }

    public boolean isSignRequest() {
        return this.signRequest;
    }

    public void setAuthnRequestBuilder(AuthnRequestBuilder authnRequestBuilder) {
        this.authnRequestBuilder = authnRequestBuilder;
    }

    public void setAssertionConsumerServiceAddress(String assertionConsumerServiceAddress) {
        this.assertionConsumerServiceAddress = assertionConsumerServiceAddress;
    }

    public void setIssuerId(String issuerId) {
        this.issuerId = issuerId;
    }

    public void setIdpServiceAddress(String idpServiceAddress) {
        this.idpServiceAddress = idpServiceAddress;
    }

    public String getIdpServiceAddress() {
        return this.idpServiceAddress;
    }

    @Override
    @PreDestroy
    public void close() {
        super.close();
    }

    private String getIssuerId(Message m) {
        if (this.issuerId == null) {
            return new UriInfoImpl(m).getBaseUri().toString();
        }
        return this.issuerId;
    }

    protected boolean checkSecurityContext(Message m) {
        HttpHeadersImpl headers = new HttpHeadersImpl(m);
        Map cookies = headers.getCookies();
        Cookie securityContextCookie = (Cookie)cookies.get("org.apache.cxf.websso.context");
        ResponseState responseState = this.getValidResponseState(securityContextCookie, m);
        if (responseState == null) {
            return false;
        }
        Cookie relayStateCookie = (Cookie)cookies.get("RelayState");
        if (relayStateCookie == null) {
            this.reportError("MISSING_RELAY_COOKIE");
            return false;
        }
        String originalRelayState = responseState.getRelayState();
        if (!originalRelayState.equals(relayStateCookie.getValue())) {
            this.reportError("INVALID_RELAY_STATE");
            return false;
        }
        try {
            String assertion = responseState.getAssertion();
            SamlAssertionWrapper assertionWrapper = new SamlAssertionWrapper(StaxUtils.read((Reader)new StringReader(assertion)).getDocumentElement());
            this.setSecurityContext(m, assertionWrapper);
        }
        catch (Exception ex) {
            this.reportError("INVALID_RESPONSE_STATE");
            return false;
        }
        return true;
    }

    protected void setSecurityContext(Message m, SamlAssertionWrapper assertionWrapper) {
        Subject subject = SAMLUtils.getSubject((Message)m, (SamlAssertionWrapper)assertionWrapper);
        String name = subject.getName();
        if (name != null) {
            String roleAttributeName = (String)SecurityUtils.getSecurityPropertyValue((String)"security.saml-role-attributename", (Message)m);
            if (roleAttributeName == null || roleAttributeName.length() == 0) {
                roleAttributeName = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role";
            }
            ClaimCollection claims = org.apache.cxf.rt.security.saml.utils.SAMLUtils.getClaims((SamlAssertionWrapper)assertionWrapper);
            Set roles = org.apache.cxf.rt.security.saml.utils.SAMLUtils.parseRolesFromClaims((ClaimCollection)claims, (String)roleAttributeName, null);
            SAMLSecurityContext context = new SAMLSecurityContext((Principal)new SimplePrincipal(name), roles, claims);
            context.setIssuer(org.apache.cxf.rt.security.saml.utils.SAMLUtils.getIssuer((Object)assertionWrapper));
            context.setAssertionElement(org.apache.cxf.rt.security.saml.utils.SAMLUtils.getAssertionElement((Object)assertionWrapper));
            m.put(SecurityContext.class, (Object)context);
        }
    }

    protected ResponseState getValidResponseState(Cookie securityContextCookie, Message m) {
        if (securityContextCookie == null) {
            this.reportTrace("MISSING_RESPONSE_STATE");
            return null;
        }
        String contextKey = securityContextCookie.getValue();
        ResponseState responseState = this.getStateProvider().getResponseState(contextKey);
        if (responseState == null) {
            this.reportError("MISSING_RESPONSE_STATE");
            return null;
        }
        if (this.isStateExpired(responseState.getCreatedAt(), responseState.getExpiresAt())) {
            this.reportError("EXPIRED_RESPONSE_STATE");
            this.getStateProvider().removeResponseState(contextKey);
            return null;
        }
        String webAppContext = this.getWebAppContext(m);
        if (this.webAppDomain != null && (responseState.getWebAppDomain() == null || !this.webAppDomain.equals(responseState.getWebAppDomain())) || responseState.getWebAppContext() == null || !webAppContext.equals(responseState.getWebAppContext())) {
            this.getStateProvider().removeResponseState(contextKey);
            this.reportError("INVALID_RESPONSE_STATE");
            return null;
        }
        if (responseState.getAssertion() == null) {
            this.reportError("INVALID_RESPONSE_STATE");
            return null;
        }
        return responseState;
    }

    protected SamlRequestInfo createSamlRequestInfo(Message m) throws Exception {
        Document doc = DOMUtils.createDocument();
        doc.appendChild(doc.createElement("root"));
        AuthnRequest authnRequest = this.authnRequestBuilder.createAuthnRequest(m, this.getIssuerId(m), this.getAbsoluteAssertionServiceAddress(m));
        if (this.isSignRequest()) {
            authnRequest.setDestination(this.idpServiceAddress);
            this.signAuthnRequest(authnRequest);
        }
        Element authnRequestElement = OpenSAMLUtil.toDom((XMLObject)authnRequest, (Document)doc);
        String authnRequestEncoded = this.encodeAuthnRequest(authnRequestElement);
        SamlRequestInfo info = new SamlRequestInfo();
        info.setSamlRequest(authnRequestEncoded);
        String webAppContext = this.getWebAppContext(m);
        String originalRequestURI = new UriInfoImpl(m).getRequestUri().toString();
        RequestState requestState = new RequestState(originalRequestURI, this.getIdpServiceAddress(), authnRequest.getID(), this.getIssuerId(m), webAppContext, this.getWebAppDomain(), System.currentTimeMillis());
        String relayState = URLEncoder.encode(UUID.randomUUID().toString(), "UTF-8");
        this.getStateProvider().setRequestState(relayState, requestState);
        info.setRelayState(relayState);
        info.setWebAppContext(webAppContext);
        info.setWebAppDomain(this.getWebAppDomain());
        return info;
    }

    protected abstract String encodeAuthnRequest(Element var1) throws IOException;

    protected abstract void signAuthnRequest(AuthnRequest var1) throws Exception;

    private String getAbsoluteAssertionServiceAddress(Message m) {
        if (this.assertionConsumerServiceAddress == null) {
            if (Boolean.TRUE.equals(JAXRSUtils.getCurrentMessage().get((Object)"org.apache.cxf.racs.is.collocated"))) {
                this.assertionConsumerServiceAddress = new UriInfoImpl(m).getAbsolutePath().toString();
            } else {
                this.reportError("MISSING_ASSERTION_SERVICE_URL");
                throw ExceptionUtils.toInternalServerErrorException(null, null);
            }
        }
        if (!this.assertionConsumerServiceAddress.startsWith("http")) {
            String httpBasePath = (String)m.get((Object)"http.base.path");
            return UriBuilder.fromUri((String)httpBasePath).path(this.assertionConsumerServiceAddress).build(new Object[0]).toString();
        }
        return this.assertionConsumerServiceAddress;
    }

    protected void reportError(String code) {
        org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message(code, BUNDLE, new Object[0]);
        LOG.warning(errorMsg.toString());
    }

    protected void reportTrace(String code) {
        if (LOG.isLoggable(Level.FINE)) {
            org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message(code, BUNDLE, new Object[0]);
            LOG.fine(errorMsg.toString());
        }
    }

    private String getWebAppContext(Message m) {
        if (this.addWebAppContext) {
            if (this.addEndpointAddressToContext) {
                return new UriInfoImpl(m).getBaseUri().getRawPath();
            }
            String httpBasePath = (String)m.get((Object)"http.base.path");
            return URI.create(httpBasePath).getRawPath();
        }
        return "/";
    }

    public String getWebAppDomain() {
        return this.webAppDomain;
    }

    public void setWebAppDomain(String webAppDomain) {
        this.webAppDomain = webAppDomain;
    }

    public void setAddWebAppContext(boolean addWebAppContext) {
        this.addWebAppContext = addWebAppContext;
    }
}

