/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.DiskStoreConfiguration;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.rs.security.saml.sso.EHCacheUtil;
import org.apache.cxf.rs.security.saml.sso.TokenReplayCache;

public class EHCacheTokenReplayCache
implements TokenReplayCache<String> {
    public static final long DEFAULT_TTL = 3600L;
    public static final long MAX_TTL = 43200L;
    public static final String CACHE_KEY = "cxf.samlp.replay.cache";
    private static final String DEFAULT_CONFIG_URL = "/cxf-samlp-ehcache.xml";
    private Ehcache cache;
    private CacheManager cacheManager;
    private long ttl = 3600L;

    public EHCacheTokenReplayCache() {
        this(DEFAULT_CONFIG_URL, null);
    }

    public EHCacheTokenReplayCache(Bus bus) {
        this(DEFAULT_CONFIG_URL, bus);
    }

    public EHCacheTokenReplayCache(String configFileURL) {
        this(configFileURL, null);
    }

    public EHCacheTokenReplayCache(String configFileURL, Bus bus) {
        this.createCache(configFileURL, bus);
    }

    private void createCache(String configFile, Bus bus) {
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus((boolean)true);
        }
        URL configFileURL = null;
        try {
            configFileURL = ResourceUtils.getClasspathResourceURL((String)configFile, EHCacheTokenReplayCache.class, (Bus)bus);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (configFileURL == null) {
            this.cacheManager = EHCacheUtil.createCacheManager();
        } else {
            Configuration conf = ConfigurationFactory.parseConfiguration((URL)configFileURL);
            if (bus != null) {
                conf.setName(bus.getId());
                DiskStoreConfiguration dsc = conf.getDiskStoreConfiguration();
                if (dsc != null && "java.io.tmpdir".equals(dsc.getOriginalPath())) {
                    String path = conf.getDiskStoreConfiguration().getPath() + File.separator + bus.getId();
                    conf.getDiskStoreConfiguration().setPath(path);
                }
            }
            this.cacheManager = EHCacheUtil.createCacheManager(conf);
        }
        CacheConfiguration cc = EHCacheUtil.getCacheConfiguration(CACHE_KEY, this.cacheManager);
        Cache newCache = new Cache(cc);
        this.cache = this.cacheManager.addCacheIfAbsent((Ehcache)newCache);
    }

    public void setTTL(long newTtl) {
        this.ttl = newTtl;
    }

    public long getTTL() {
        return this.ttl;
    }

    @Override
    public void putId(String id) {
        this.putId(id, this.ttl);
    }

    @Override
    public void putId(String id, long timeToLive) {
        if (id == null || "".equals(id)) {
            return;
        }
        int parsedTTL = (int)timeToLive;
        if ((timeToLive != (long)parsedTTL || parsedTTL < 0 || (long)parsedTTL > 43200L) && this.ttl != (long)(parsedTTL = (int)this.ttl)) {
            parsedTTL = 3600;
        }
        Element element = new Element((Object)id, (Object)id, parsedTTL, parsedTTL);
        element.resetAccessStatistics();
        this.cache.put(element);
    }

    @Override
    public String getId(String id) {
        Element element = this.cache.get((Serializable)((Object)id));
        if (element != null) {
            if (this.cache.isExpired(element)) {
                this.cache.remove((Serializable)((Object)id));
                return null;
            }
            return (String)element.getObjectValue();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.cacheManager != null) {
            this.cacheManager.shutdown();
            this.cacheManager = null;
            this.cache = null;
        }
    }
}

